/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.aop.microcontainer.aspects.jmx.JMX;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.deployer.SchemaResolverDeployer;
import org.jboss.deployment.EARDeployment;
import org.jboss.deployment.JBossAppParsingDeployerMBean;
import org.jboss.metadata.common.jboss.LoaderRepositoryConfigMetaData;
import org.jboss.metadata.common.jboss.LoaderRepositoryMetaData;
import org.jboss.metadata.ear.jboss.JBossAppMetaData;
import org.jboss.metadata.ear.spec.EarMetaData;
import org.jboss.mx.loading.LoaderRepositoryFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JMX(name="jboss.j2ee:service=EARDeployer", exposedInterface=JBossAppParsingDeployerMBean.class)
public class JBossAppParsingDeployer
extends SchemaResolverDeployer<JBossAppMetaData>
implements JBossAppParsingDeployerMBean {
    private boolean isolated = false;
    private boolean callByValue = false;
    private String unauthenticatedIdentity = null;

    public JBossAppParsingDeployer() {
        super(JBossAppMetaData.class);
        this.setName("jboss-app.xml");
    }

    public String getAppXmlPath() {
        return this.getName();
    }

    public void setAppXmlPath(String appXmlPath) {
        this.setName(appXmlPath);
    }

    @Override
    public boolean isIsolated() {
        return this.isolated;
    }

    @Override
    public void setIsolated(boolean isolated) {
        this.isolated = isolated;
    }

    @Override
    public boolean isCallByValue() {
        return this.callByValue;
    }

    @Override
    public void setCallByValue(boolean callByValue) {
        this.callByValue = callByValue;
    }

    public String getUnauthenticatedIdentity() {
        return this.unauthenticatedIdentity;
    }

    public void setUnauthenticatedIdentity(String unauthenticatedIdentity) {
        this.unauthenticatedIdentity = unauthenticatedIdentity;
    }

    protected void createMetaData(DeploymentUnit unit, String name, String suffix) throws DeploymentException {
        super.createMetaData(unit, name, suffix);
        EarMetaData specMetaData = (EarMetaData)unit.getAttachment(EarMetaData.class);
        JBossAppMetaData metaData = (JBossAppMetaData)unit.getAttachment(JBossAppMetaData.class);
        if (specMetaData == null && metaData == null) {
            return;
        }
        LoaderRepositoryFactory.LoaderRepositoryConfig loaderCfg = null;
        if (metaData == null) {
            metaData = new JBossAppMetaData();
        } else {
            LoaderRepositoryMetaData lrmd = metaData.getLoaderRepository();
            if (lrmd != null) {
                Set configs;
                loaderCfg = new LoaderRepositoryFactory.LoaderRepositoryConfig();
                loaderCfg.repositoryClassName = lrmd.getLoaderRepositoryClass();
                if (lrmd.getName() != null) {
                    try {
                        loaderCfg.repositoryName = new ObjectName(lrmd.getName());
                    }
                    catch (MalformedObjectNameException e) {
                        throw new DeploymentException("Invalid object name: " + lrmd.getName(), (Throwable)e);
                    }
                }
                if ((configs = lrmd.getLoaderRepositoryConfig()) != null && !configs.isEmpty()) {
                    LoaderRepositoryConfigMetaData config = (LoaderRepositoryConfigMetaData)configs.iterator().next();
                    loaderCfg.configParserClassName = config.getConfigParserClass();
                    loaderCfg.repositoryConfig = config.getConfig();
                }
            }
        }
        if (loaderCfg == null && this.isolated) {
            loaderCfg = this.initLoaderRepository(metaData, unit);
        }
        if (loaderCfg != null) {
            unit.addAttachment(LoaderRepositoryFactory.LoaderRepositoryConfig.class, (Object)loaderCfg);
        }
        JBossAppMetaData mergedMetaData = new JBossAppMetaData();
        mergedMetaData.merge(metaData, specMetaData);
        unit.getTransientManagedObjects().addAttachment(JBossAppMetaData.class, (Object)mergedMetaData);
        unit.addAttachment("Raw" + JBossAppMetaData.class.getName(), (Object)metaData, JBossAppMetaData.class);
        if (this.isCallByValue()) {
            unit.addAttachment("EAR.callByValue", (Object)Boolean.TRUE, Boolean.class);
        }
        if (this.unauthenticatedIdentity != null) {
            unit.addAttachment("EAR.unauthenticatedIdentity", (Object)this.unauthenticatedIdentity, String.class);
        }
    }

    protected LoaderRepositoryFactory.LoaderRepositoryConfig initLoaderRepository(JBossAppMetaData metaData, DeploymentUnit unit) throws DeploymentException {
        try {
            String name = EARDeployment.getJMXName(metaData, unit) + ",extension=LoaderRepository";
            ObjectName objectName = new ObjectName(name);
            LoaderRepositoryFactory.LoaderRepositoryConfig config = new LoaderRepositoryFactory.LoaderRepositoryConfig();
            config.repositoryName = objectName;
            return config;
        }
        catch (Exception e) {
            throw new DeploymentException("Failed to create LoaderRepositoryConfig", (Throwable)e);
        }
    }
}

