/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.logging.metadata;

import java.util.List;

import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.xb.annotations.JBossXmlType;
import org.jboss.xb.annotations.JBossXmlConstants;

@XmlType(name = "multiFilterType", propOrder = {})
@JBossXmlType(modelGroup = JBossXmlConstants.MODEL_GROUP_CHOICE)
public abstract class AbstractMultiFilterMetaData {
    private List<Object> filterMetaDataList;

    public List<Object> getFilterMetaDataList() {
        return filterMetaDataList;
    }

    @XmlElements({
            @XmlElement(name = "all", type = AllFilterMetaData.class),
            @XmlElement(name = "any", type = AnyFilterMetaData.class),
            @XmlElement(name = "accept", type = AcceptFilterMetaData.class),
            @XmlElement(name = "deny", type = DenyFilterMetaData.class),
            @XmlElement(name = "not", type = NotFilterMetaData.class),
            @XmlElement(name = "match", type = MatchFilterMetaData.class),
            @XmlElement(name = "replace", type = ReplaceFilterMetaData.class),
            @XmlElement(name = "level", type = LevelFilterMetaData.class),
            @XmlElement(name = "level-range", type = LevelRangeFilterMetaData.class),
            @XmlElement(name = "change-level", type = LevelChangeFilterMetaData.class),

            @XmlElement(name = "value", type = ValueMetaData.class),

            @XmlElement(name = "filter-ref", type = RefMetaData.class)
    })
    public void setFilterMetaDataList(final List<Object> filterMetaDataList) {
        this.filterMetaDataList = filterMetaDataList;
    }
}
