/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.logging.metadata;

import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.ClassLoaderLogContextSelector;

/**
 * A helper class which can be created and managed by the Microcontainer, which registers the associated classloader
 * with the log context selector.
 */
public final class ClassLoaderRegistrationHelper {
    private ClassLoader classLoader;
    private LogContext logContext;
    private ClassLoaderLogContextSelector selector;

    public void start() {
        selector.registerLogContext(classLoader, logContext);
    }

    public void stop() {
        selector.unregisterLogContext(classLoader, logContext);
    }

    public ClassLoader getClassLoader() {
        return classLoader;
    }

    public void setClassLoader(final ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public LogContext getLogContext() {
        return logContext;
    }

    public void setLogContext(final LogContext logContext) {
        this.logContext = logContext;
    }

    public ClassLoaderLogContextSelector getSelector() {
        return selector;
    }

    public void setSelector(final ClassLoaderLogContextSelector selector) {
        this.selector = selector;
    }
}
