/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.logging.metadata;

import java.util.Set;

import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractPropertyMetaData;
import org.jboss.beans.metadata.spi.ClassLoaderMetaData;
import org.jboss.beans.metadata.spi.PropertyMetaData;

/**
 * Hack on how to get bean's explicit classloader.
 *
 * @author ales.justin@jboss.org
 */
class GetClassLoaderBeanMetaData extends AbstractBeanMetaData {

    private static final long serialVersionUID = 5222416088266093151L;

    /**
     * The CL property name
     */
    private String clPropertyName = "classLoader";

    GetClassLoaderBeanMetaData(String name, String beanClass) {
        super(name, beanClass);
    }

    public void setClassLoader(ClassLoaderMetaData classLoaderMetaData) {
        super.setClassLoader(classLoaderMetaData);
        addProperty(new AbstractPropertyMetaData(clPropertyName, classLoaderMetaData.getClassLoader()));
    }

    // So that the call order is not important - e.g. setCL before setProps.
    public void setProperties(Set<PropertyMetaData> propertyMetaDatas) {
        if (propertyMetaDatas != null) {
            Set<PropertyMetaData> properties = getProperties();
            if (properties != null) {
                properties.addAll(propertyMetaDatas);
            } else {
                super.setProperties(propertyMetaDatas);
            }
        }
    }

    /**
     * Set CL property name.
     *
     * @param clPropertyName the cl property name
     */
    public void setClPropertyName(String clPropertyName) {
        if (clPropertyName == null)
            throw new IllegalArgumentException("Null CL property name.");
        this.clPropertyName = clPropertyName;
    }
}