/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.logging.metadata;


public final class LoggingObjectRef {
    private final String name;
    private final String context;
    private final Kind kind;

    public LoggingObjectRef(final String name, final String context, final Kind kind) {
        this.name = name;
        this.context = context;
        this.kind = kind;
    }

    public String getName() {
        return name;
    }

    public String getContext() {
        return context;
    }

    public Kind getKind() {
        return kind;
    }

    public boolean equals(final Object o) {
        if (this == o) return true;
        if (! (o instanceof LoggingObjectRef)) return false;
        final LoggingObjectRef ref = (LoggingObjectRef) o;
        if (kind != ref.kind) return false;
        if (!name.equals(ref.name)) return false;
        if (!context.equals(ref.context)) return false;
        return true;
    }

    public int hashCode() {
        int result = name.hashCode();
        result = 31 * result + context.hashCode();
        result = 31 * result + kind.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder b = new StringBuilder(64);
        b.append("Logging:");
        b.append(kind);
        b.append(':');
        b.append(context);
        b.append(':');
        b.append(name);
        return b.toString();
    }

    public enum Kind {
        FORMATTER,
        HANDLER,
        FILTER,
        LOGGER,
    }
}
