/*
 * Decompiled with CFR 0.152.
 */
package org.mockejb.interceptor;

import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.mockejb.interceptor.PointcutException;

class RegexpWrapper {
    private Pattern pattern;
    private String patternString;
    private PatternCompiler compiler = new Perl5Compiler();
    private PatternMatcher matcher = new Perl5Matcher();

    public RegexpWrapper(String patternString) {
        this.patternString = patternString;
        try {
            this.pattern = this.compiler.compile(patternString);
        }
        catch (MalformedPatternException mpe) {
            throw new PointcutException(mpe.getMessage(), mpe);
        }
    }

    public boolean containedInString(String stringToMatch) {
        return this.matcher.contains(stringToMatch, this.pattern);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RegexpWrapper)) {
            return false;
        }
        RegexpWrapper regexpWrapper = (RegexpWrapper)obj;
        return this.patternString.equals(regexpWrapper.patternString);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.patternString.hashCode();
        return result;
    }
}

