/*
 * Decompiled with CFR 0.152.
 */
package org.mockejb.jms;

import java.util.Enumeration;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import org.mockejb.jms.MessageImpl;
import org.mockejb.jms.PrimitiveMap;

public class MapMessageImpl
extends MessageImpl
implements MapMessage {
    private final PrimitiveMap map = new PrimitiveMap();

    public MapMessageImpl() {
    }

    public MapMessageImpl(MapMessage msg) throws JMSException {
        super((Message)msg);
        Enumeration e = msg.getMapNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            this.setObject(name, msg.getObject(name));
        }
    }

    public boolean getBoolean(String name) throws JMSException {
        return this.map.getBoolean(name);
    }

    public byte getByte(String name) throws JMSException {
        return this.map.getByte(name);
    }

    public short getShort(String name) throws JMSException {
        return this.map.getShort(name);
    }

    public char getChar(String name) throws JMSException {
        return this.map.getChar(name);
    }

    public int getInt(String name) throws JMSException {
        return this.map.getInt(name);
    }

    public long getLong(String name) throws JMSException {
        return this.map.getLong(name);
    }

    public float getFloat(String name) throws JMSException {
        return this.map.getFloat(name);
    }

    public double getDouble(String name) throws JMSException {
        return this.map.getDouble(name);
    }

    public String getString(String name) throws JMSException {
        return this.map.getString(name);
    }

    public byte[] getBytes(String name) throws JMSException {
        return this.map.getBytes(name);
    }

    public Object getObject(String name) throws JMSException {
        return this.map.getObject(name);
    }

    public Enumeration getMapNames() throws JMSException {
        return this.map.getNames();
    }

    public void setBoolean(String name, boolean value) throws JMSException {
        this.checkBodyWriteable();
        this.map.setBoolean(name, value);
    }

    public void setByte(String name, byte value) throws JMSException {
        this.checkBodyWriteable();
        this.map.setByte(name, value);
    }

    public void setShort(String name, short value) throws JMSException {
        this.checkBodyWriteable();
        this.map.setShort(name, value);
    }

    public void setChar(String name, char value) throws JMSException {
        this.checkBodyWriteable();
        this.map.setChar(name, value);
    }

    public void setInt(String name, int value) throws JMSException {
        this.checkBodyWriteable();
        this.map.setInt(name, value);
    }

    public void setLong(String name, long value) throws JMSException {
        this.checkBodyWriteable();
        this.map.setLong(name, value);
    }

    public void setFloat(String name, float value) throws JMSException {
        this.checkBodyWriteable();
        this.map.setFloat(name, value);
    }

    public void setDouble(String name, double value) throws JMSException {
        this.checkBodyWriteable();
        this.map.setDouble(name, value);
    }

    public void setString(String name, String value) throws JMSException {
        this.checkBodyWriteable();
        this.map.setString(name, value);
    }

    public void setBytes(String name, byte[] value) throws JMSException {
        this.checkBodyWriteable();
        this.map.setBytes(name, value);
    }

    public void setBytes(String name, byte[] value, int offset, int length) throws JMSException {
        this.checkBodyWriteable();
        if (value == null || length < 0 || offset < 0 || offset + length > value.length) {
            throw new IllegalArgumentException();
        }
        byte[] valueToSet = new byte[length];
        int i = 0;
        while (length > 0) {
            valueToSet[i++] = value[offset++];
            --length;
        }
        this.map.setBytes(name, valueToSet);
    }

    public void setObject(String name, Object value) throws JMSException {
        this.checkBodyWriteable();
        this.map.setObject(name, value);
    }

    public boolean itemExists(String name) throws JMSException {
        return this.map.containsKey(name);
    }

    void resetBody() throws JMSException {
        this.setBodyReadOnly();
    }
}

