/*
 * Decompiled with CFR 0.152.
 */
package org.mockejb.jms;

import java.util.Enumeration;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import org.mockejb.jms.PrimitiveMap;

public class MessageImpl
implements Message {
    private static final int MODE_READ_ONLY = 100;
    private static final int MODE_WRITE_ONLY = 200;
    private int bodyMode = 200;
    private boolean propertiesWriteable = true;
    private String jmsType;
    private long jmsTimestamp;
    private Destination jmsReplyTo;
    private int jmsPriority;
    private String jmsMessageId;
    private long jmsExpiration;
    private Destination jmsDestination;
    private int jmsDeliveryMode;
    private String jmsCorrelationId;
    private final PrimitiveMap properties = new PrimitiveMap();

    public MessageImpl() {
    }

    public MessageImpl(Message msg) throws JMSException {
        this.setJMSMessageID(msg.getJMSMessageID());
        this.setJMSTimestamp(msg.getJMSTimestamp());
        this.setJMSCorrelationID(msg.getJMSCorrelationID());
        this.setJMSReplyTo(msg.getJMSReplyTo());
        this.setJMSDestination(msg.getJMSDestination());
        this.setJMSDeliveryMode(msg.getJMSDeliveryMode());
        this.setJMSRedelivered(msg.getJMSRedelivered());
        this.setJMSType(msg.getJMSType());
        this.setJMSExpiration(msg.getJMSExpiration());
        this.setJMSPriority(msg.getJMSPriority());
        Enumeration e = msg.getPropertyNames();
        while (e.hasMoreElements()) {
            String propertyName = (String)e.nextElement();
            this.setObjectProperty(propertyName, msg.getObjectProperty(propertyName));
        }
    }

    public String getJMSMessageID() throws JMSException {
        return this.jmsMessageId;
    }

    public void setJMSMessageID(String messageId) throws JMSException {
        this.jmsMessageId = messageId;
    }

    public long getJMSTimestamp() throws JMSException {
        return this.jmsTimestamp;
    }

    public void setJMSTimestamp(long timestamp) throws JMSException {
        this.jmsTimestamp = timestamp;
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        throw new UnsupportedOperationException();
    }

    public void setJMSCorrelationIDAsBytes(byte[] arg0) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public void setJMSCorrelationID(String correlationId) throws JMSException {
        this.jmsCorrelationId = correlationId;
    }

    public String getJMSCorrelationID() throws JMSException {
        return this.jmsCorrelationId;
    }

    public Destination getJMSReplyTo() throws JMSException {
        return this.jmsReplyTo;
    }

    public void setJMSReplyTo(Destination replyTo) throws JMSException {
        this.jmsReplyTo = replyTo;
    }

    public Destination getJMSDestination() throws JMSException {
        return this.jmsDestination;
    }

    public void setJMSDestination(Destination destination) throws JMSException {
        this.jmsDestination = destination;
    }

    public int getJMSDeliveryMode() throws JMSException {
        return this.jmsDeliveryMode;
    }

    public void setJMSDeliveryMode(int deliveryMode) throws JMSException {
        this.jmsDeliveryMode = deliveryMode;
    }

    public boolean getJMSRedelivered() throws JMSException {
        return false;
    }

    public void setJMSRedelivered(boolean redelivered) throws JMSException {
    }

    public String getJMSType() throws JMSException {
        return this.jmsType;
    }

    public void setJMSType(String type) throws JMSException {
        this.jmsType = type;
    }

    public long getJMSExpiration() throws JMSException {
        return this.jmsExpiration;
    }

    public void setJMSExpiration(long expiration) throws JMSException {
        this.jmsExpiration = expiration;
    }

    public int getJMSPriority() throws JMSException {
        return this.jmsPriority;
    }

    public void setJMSPriority(int priority) throws JMSException {
        this.jmsPriority = priority;
    }

    public void clearProperties() throws JMSException {
        this.propertiesWriteable = true;
        this.properties.clear();
    }

    public boolean propertyExists(String propertyName) throws JMSException {
        return this.properties.containsKey(propertyName);
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        return this.properties.getBoolean(name);
    }

    public byte getByteProperty(String name) throws JMSException {
        return this.properties.getByte(name);
    }

    public short getShortProperty(String name) throws JMSException {
        return this.properties.getShort(name);
    }

    public int getIntProperty(String name) throws JMSException {
        return this.properties.getInt(name);
    }

    public long getLongProperty(String name) throws JMSException {
        return this.properties.getLong(name);
    }

    public float getFloatProperty(String name) throws JMSException {
        return this.properties.getFloat(name);
    }

    public double getDoubleProperty(String name) throws JMSException {
        return this.properties.getDouble(name);
    }

    public String getStringProperty(String name) throws JMSException {
        return this.properties.getString(name);
    }

    public Object getObjectProperty(String name) throws JMSException {
        return this.properties.getObject(name);
    }

    public Enumeration getPropertyNames() throws JMSException {
        return this.properties.getNames();
    }

    public void setBooleanProperty(String name, boolean value) throws JMSException {
        this.checkPropertiesWriteable();
        this.properties.setBoolean(name, value);
    }

    public void setByteProperty(String name, byte value) throws JMSException {
        this.checkPropertiesWriteable();
        this.properties.setByte(name, value);
    }

    public void setShortProperty(String name, short value) throws JMSException {
        this.checkPropertiesWriteable();
        this.properties.setShort(name, value);
    }

    public void setIntProperty(String name, int value) throws JMSException {
        this.checkPropertiesWriteable();
        this.properties.setInt(name, value);
    }

    public void setLongProperty(String name, long value) throws JMSException {
        this.checkPropertiesWriteable();
        this.properties.setLong(name, value);
    }

    public void setFloatProperty(String name, float value) throws JMSException {
        this.checkPropertiesWriteable();
        this.properties.setFloat(name, value);
    }

    public void setDoubleProperty(String name, double value) throws JMSException {
        this.checkPropertiesWriteable();
        this.properties.setDouble(name, value);
    }

    public void setStringProperty(String name, String value) throws JMSException {
        this.checkPropertiesWriteable();
        this.properties.setString(name, value);
    }

    public void setObjectProperty(String name, Object value) throws JMSException {
        this.checkPropertiesWriteable();
        this.properties.setObject(name, value);
    }

    public void acknowledge() throws JMSException {
    }

    public void clearBody() throws JMSException {
        this.bodyMode = 200;
    }

    private boolean propertiesWriteable() {
        return this.propertiesWriteable;
    }

    public void setPropertiesNotWriteable() {
        this.propertiesWriteable = false;
    }

    private void checkPropertiesWriteable() throws MessageNotWriteableException {
        if (!this.propertiesWriteable()) {
            throw new MessageNotWriteableException("Message is in read-only mode!");
        }
    }

    void setBodyReadOnly() {
        this.bodyMode = 100;
    }

    void checkBodyReadable() throws JMSException {
        if (this.bodyMode == 200) {
            throw new MessageNotReadableException("Message is not in Read-Only mode!");
        }
    }

    void checkBodyWriteable() throws JMSException {
        if (this.bodyMode == 100) {
            throw new MessageNotWriteableException("Message is not in Write-Only mode!");
        }
    }

    void resetBody() throws JMSException {
    }
}

