/*
 * Decompiled with CFR 0.152.
 */
package org.mockejb.jms;

import java.io.Serializable;
import java.util.Enumeration;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.mockejb.jms.BytesMessageImpl;
import org.mockejb.jms.MapMessageImpl;
import org.mockejb.jms.MessageImpl;
import org.mockejb.jms.ObjectMessageImpl;
import org.mockejb.jms.StreamMessageImpl;
import org.mockejb.jms.TextMessageImpl;

public final class MessageUtility {
    private MessageUtility() {
    }

    public static boolean compare(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 != null && s2 != null) {
            return s1.equals(s2);
        }
        return false;
    }

    public static boolean compare(byte[] bytes1, byte[] bytes2) {
        if (bytes1.length != bytes2.length) {
            return false;
        }
        for (int i = 0; i < bytes1.length; ++i) {
            if (bytes1[i] == bytes2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean compare(Message msg1, Message msg2) throws JMSException {
        if (MessageUtility.compare(msg1.getJMSCorrelationID(), msg2.getJMSCorrelationID()) && msg1.getJMSDeliveryMode() == msg2.getJMSDeliveryMode() && msg1.getJMSDestination() == msg2.getJMSDestination() && msg1.getJMSExpiration() == msg2.getJMSExpiration() && MessageUtility.compare(msg1.getJMSMessageID(), msg2.getJMSMessageID()) && msg1.getJMSPriority() == msg2.getJMSPriority() && msg1.getJMSReplyTo() == msg2.getJMSReplyTo() && msg1.getJMSTimestamp() == msg2.getJMSTimestamp() && MessageUtility.compare(msg1.getJMSType(), msg2.getJMSType()) && msg1.getJMSRedelivered() == msg2.getJMSRedelivered()) {
            int numOfProperties2;
            Enumeration names = msg1.getPropertyNames();
            int numOfProperties1 = 0;
            while (names.hasMoreElements()) {
                ++numOfProperties1;
                String name = (String)names.nextElement();
                if (!msg2.propertyExists(name)) {
                    return false;
                }
                Object value1 = msg1.getObjectProperty(name);
                Object value2 = msg2.getObjectProperty(name);
                if (value1 == null && value2 == null || value1 != null && value2 != null && value1.equals(value2)) continue;
                return false;
            }
            names = msg2.getPropertyNames();
            for (numOfProperties2 = 0; names.hasMoreElements() && numOfProperties2 <= numOfProperties1; ++numOfProperties2) {
                names.nextElement();
            }
            return numOfProperties1 == numOfProperties2;
        }
        return false;
    }

    public static boolean compare(BytesMessage msg1, BytesMessage msg2) throws JMSException {
        BytesMessageImpl m1 = new BytesMessageImpl(msg1);
        BytesMessageImpl m2 = new BytesMessageImpl(msg2);
        m1.reset();
        m2.reset();
        int length = (int)m1.getBodyLength();
        if (length != (int)m2.getBodyLength()) {
            return false;
        }
        while (length-- > 0) {
            if (m1.readByte() == m2.readByte()) continue;
            return false;
        }
        return MessageUtility.compare(m1, m2);
    }

    public static boolean compare(MapMessage msg1, MapMessage msg2) throws JMSException {
        int numOfNames2;
        Enumeration names = msg1.getMapNames();
        int numOfNames1 = 0;
        while (names.hasMoreElements()) {
            ++numOfNames1;
            String name = (String)names.nextElement();
            if (!msg2.itemExists(name)) {
                return false;
            }
            Object value1 = msg1.getObject(name);
            Object value2 = msg2.getObject(name);
            if (value1 == null && value2 == null || value1 != null && value2 != null && (value1 instanceof byte[] && value2 instanceof byte[] && MessageUtility.compare((byte[])value1, (byte[])value2) || value1.equals(value2))) continue;
            return false;
        }
        names = msg2.getMapNames();
        for (numOfNames2 = 0; names.hasMoreElements() && numOfNames2 <= numOfNames1; ++numOfNames2) {
            names.nextElement();
        }
        return numOfNames1 == numOfNames2 && MessageUtility.compare((Message)msg1, (Message)msg2);
    }

    public static boolean compare(ObjectMessage msg1, ObjectMessage msg2) throws JMSException {
        Serializable o1 = msg1.getObject();
        Serializable o2 = msg2.getObject();
        if (o1 == null && o2 == null) {
            return MessageUtility.compare((Message)msg1, (Message)msg2);
        }
        if (o1 != null && o2 != null) {
            return o1.equals(o2) && MessageUtility.compare((Message)msg1, (Message)msg2);
        }
        return false;
    }

    public static boolean compare(StreamMessage msg1, StreamMessage msg2) throws JMSException {
        Object[] data2;
        StreamMessageImpl m1 = new StreamMessageImpl(msg1);
        StreamMessageImpl m2 = new StreamMessageImpl(msg2);
        Object[] data1 = m1.getStreamData();
        if (data1.length != (data2 = m2.getStreamData()).length) {
            return false;
        }
        for (int i = 0; i < data1.length; ++i) {
            if (data1[i] == null && data2[i] == null || data1[i] != null && data2[i] != null && (data1[i] instanceof byte[] && data2[i] instanceof byte[] && MessageUtility.compare((byte[])data1[i], (byte[])data2[i]) || data1[i].equals(data2[i]))) continue;
            return false;
        }
        return MessageUtility.compare(m1, m2);
    }

    public static boolean compare(TextMessage msg1, TextMessage msg2) throws JMSException {
        return MessageUtility.compare(msg1.getText(), msg2.getText()) && MessageUtility.compare((Message)msg1, (Message)msg2);
    }

    public static MessageImpl copyMessage(Message msg, boolean reset) throws JMSException {
        MessageImpl result = msg instanceof BytesMessage ? new BytesMessageImpl((BytesMessage)msg) : (msg instanceof MapMessage ? new MapMessageImpl((MapMessage)msg) : (msg instanceof ObjectMessage ? new ObjectMessageImpl(((ObjectMessage)msg).getObject()) : (msg instanceof StreamMessage ? new StreamMessageImpl((StreamMessage)msg) : (msg instanceof TextMessage ? new TextMessageImpl((TextMessage)msg) : new MessageImpl(msg)))));
        if (reset) {
            result.setPropertiesNotWriteable();
            result.resetBody();
        }
        return result;
    }
}

