/*
 * Decompiled with CFR 0.152.
 */
package org.mockejb.jms;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import org.mockejb.MethodNotImplementedException;
import org.mockejb.jms.ConnectionMetaDataImpl;
import org.mockejb.jms.MockSession;

abstract class MockConnection
implements Connection {
    private String clientId;
    private boolean closed = false;
    private boolean started = false;
    private final List sessions = new ArrayList();

    MockConnection(String id) {
        this.clientId = id;
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkClosed();
        MockSession sess = this.createMockSession(transacted, acknowledgeMode);
        this.sessions.add(sess);
        return sess;
    }

    public String getClientID() throws JMSException {
        this.checkClosed();
        return this.clientId;
    }

    public void setClientID(String arg0) throws JMSException {
        throw new IllegalStateException("Client ID can not be set!");
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        this.checkClosed();
        return new ConnectionMetaDataImpl();
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        throw new MethodNotImplementedException("getExceptionListener", "QueueConnectionImpl");
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        throw new MethodNotImplementedException("setExceptionListener", "QueueConnectionImpl");
    }

    public void close() throws JMSException {
        if (this.closed) {
            return;
        }
        this.stop();
        ListIterator it = this.sessions.listIterator();
        while (it.hasNext()) {
            Session s = (Session)it.next();
            s.close();
            it.remove();
        }
        this.closed = true;
    }

    public void start() throws JMSException {
        this.checkClosed();
        this.started = true;
        Iterator it = this.sessions.iterator();
        while (it.hasNext()) {
            MockSession sess = (MockSession)it.next();
            sess.consumeMessages();
        }
    }

    public void stop() throws JMSException {
        this.checkClosed();
        this.started = false;
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new MethodNotImplementedException("createConnectionConsumer", "MockConnection");
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new MethodNotImplementedException("createDurableConnectionConsumer", "MockConnection");
    }

    void checkClosed() throws IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("Unable to perform operation on closed connection!");
        }
    }

    abstract MockSession createMockSession(boolean var1, int var2);

    boolean isStarted() {
        return this.started;
    }
}

