/*
 * Decompiled with CFR 0.152.
 */
package org.mockejb.jms;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import org.mockejb.jms.MessageImpl;
import org.mockejb.jms.MessageUtility;
import org.mockejb.jms.MockConsumer;

abstract class MockDestination
implements Destination {
    private String name;
    private List messages = new ArrayList();
    private List consumers = new ArrayList();

    MockDestination(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    void addMessage(Message msg) throws JMSException {
        int i;
        MessageImpl sentMsg = MessageUtility.copyMessage(msg, true);
        for (i = 0; i < this.messages.size() && msg.getJMSPriority() <= ((Message)this.messages.get(i)).getJMSPriority(); ++i) {
        }
        this.messages.add(i, sentMsg);
        Iterator it = this.consumers.iterator();
        while (it.hasNext()) {
            MockConsumer cons = (MockConsumer)it.next();
            cons.consume(sentMsg);
        }
    }

    public void clear() {
        this.messages.clear();
    }

    public String toString() {
        return this.getClass().getName() + " with name: " + this.getName();
    }

    public int size() {
        return this.messages.size();
    }

    public Message getMessageAt(int index) {
        return (Message)this.messages.get(index);
    }

    public List getMessages() {
        return this.messages;
    }

    void registerConsumer(MockConsumer consumer) throws JMSException {
        this.cleanConsumers();
        consumer.consume(this.messages);
        this.consumers.add(consumer);
    }

    void removeConsumer(MockConsumer consumer) {
        this.consumers.remove(consumer);
    }

    private void cleanConsumers() {
        ListIterator it = this.consumers.listIterator();
        while (it.hasNext()) {
            MockConsumer cons = (MockConsumer)it.next();
            if (!cons.isClosed()) continue;
            it.remove();
        }
    }
}

