/*
 * Decompiled with CFR 0.152.
 */
package org.mockejb.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import org.mockejb.jms.MessageImpl;

public class ObjectMessageImpl
extends MessageImpl
implements ObjectMessage {
    private byte[] serializedObject = null;

    public ObjectMessageImpl() {
    }

    public ObjectMessageImpl(Serializable object) throws JMSException {
        this.setObject(object);
    }

    public ObjectMessageImpl(ObjectMessage msg) throws JMSException {
        super((Message)msg);
        this.setObject(msg.getObject());
    }

    public void setObject(Serializable object) throws JMSException {
        this.checkBodyWriteable();
        try {
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            ObjectOutputStream objectOut = new ObjectOutputStream(bytesOut);
            objectOut.writeObject(object);
            objectOut.flush();
            objectOut.close();
            this.serializedObject = bytesOut.toByteArray();
            bytesOut.close();
        }
        catch (IOException ex) {
            throw new JMSException(ex.getMessage());
        }
    }

    public Serializable getObject() throws JMSException {
        if (this.serializedObject == null) {
            return null;
        }
        try {
            ByteArrayInputStream bytesIn = new ByteArrayInputStream(this.serializedObject);
            ObjectInputStream objectIn = new ObjectInputStream(bytesIn);
            Serializable result = (Serializable)objectIn.readObject();
            objectIn.close();
            bytesIn.close();
            return result;
        }
        catch (IOException ex) {
            throw new JMSException(ex.getMessage());
        }
        catch (ClassNotFoundException ex) {
            throw new JMSException(ex.getMessage());
        }
    }

    public void clearBody() throws JMSException {
        super.clearBody();
        this.serializedObject = null;
    }

    void resetBody() throws JMSException {
        this.setBodyReadOnly();
    }
}

