/*
 * Decompiled with CFR 0.152.
 */
package org.mockejb.jms;

import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import org.mockejb.MethodNotImplementedException;
import org.mockejb.jms.MockConnection;
import org.mockejb.jms.MockConsumer;
import org.mockejb.jms.MockDestination;
import org.mockejb.jms.MockProducer;
import org.mockejb.jms.MockQueue;
import org.mockejb.jms.MockSession;
import org.mockejb.jms.QueueBrowserImpl;
import org.mockejb.jms.QueueReceiverImpl;
import org.mockejb.jms.QueueSenderImpl;

class QueueSessionImpl
extends MockSession
implements QueueSession {
    QueueSessionImpl(boolean transacted, int acknowledgeMode, MockConnection connection) {
        super(transacted, acknowledgeMode, connection);
    }

    public Queue createQueue(String queueName) throws JMSException {
        throw new MethodNotImplementedException("createQueue", "QueueSessionImpl");
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        this.checkClosed();
        return (QueueReceiver)this.createConsumer((Destination)queue);
    }

    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        throw new MethodNotImplementedException("createReceiver", "QueueSessionImpl");
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        this.checkClosed();
        return (QueueSender)this.createProducer((Destination)queue);
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        this.checkClosed();
        if (queue instanceof MockQueue) {
            return new QueueBrowserImpl((MockQueue)queue);
        }
        throw new InvalidDestinationException("Invalid queue specified!");
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        throw new MethodNotImplementedException("createBrowser", "QueueSession");
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        throw new MethodNotImplementedException("createTemporaryQueue", "QueueSession");
    }

    public Topic createTopic(String topicName) throws JMSException {
        throw new IllegalStateException("Queue session can not create topic!");
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        throw new IllegalStateException("Queue session can not create subscriber!");
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        throw new IllegalStateException("Queue session can not create subscriber!");
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        throw new IllegalStateException("Queue session can not create temporary topic!");
    }

    public void unsubscribe(String name) throws JMSException {
        throw new IllegalStateException("Queue session can not \"unsubscribe\"!");
    }

    MockConsumer createMockConsumer(MockDestination destination) throws JMSException {
        if (destination instanceof MockQueue) {
            return new QueueReceiverImpl((MockSession)this, (MockQueue)destination);
        }
        throw new InvalidDestinationException("Invalid queue specified!");
    }

    MockProducer createMockProducer(MockDestination destination) throws JMSException {
        if (destination instanceof MockQueue) {
            return new QueueSenderImpl((MockQueue)destination);
        }
        throw new InvalidDestinationException("Invalid queue specified!");
    }
}

