/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.installer.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.ext.spring.util.SpringSupport;
import net.shibboleth.idp.installer.metadata.MetadataGenerator;
import net.shibboleth.idp.installer.metadata.MetadataGeneratorParameters;
import net.shibboleth.idp.spring.IdPPropertiesApplicationContextInitializer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ClassPathResource;

public class MetadataGeneratorTask
extends Task {
    private File outputFile;
    @Nullable
    private String idpHome;
    @Nullable
    private File encryptionCert;
    @Nullable
    private File signingCert;
    @Nullable
    private File backchannelCert;
    @Nullable
    private String entityID;
    @Nullable
    private String dnsName;
    @Nullable
    private String scope;
    private boolean saml2AttributeQueryCommented = true;

    @Nullable
    public String getIdpHome() {
        return this.idpHome;
    }

    public void setIdpHome(@Nullable String home) {
        this.idpHome = home;
    }

    public void setOutput(File file) {
        this.outputFile = file;
    }

    public void setEncryptionCert(File file) {
        this.encryptionCert = file;
    }

    public void setSigningCert(File file) {
        this.signingCert = file;
    }

    public void setBackchannelCert(File file) {
        this.backchannelCert = file;
    }

    public void setEntityID(String id) {
        this.entityID = id;
    }

    public void setDnsName(String name) {
        this.dnsName = name;
    }

    public void setScope(String value) {
        this.scope = value;
    }

    public boolean isSAML2AttributeQueryCommented() {
        return this.saml2AttributeQueryCommented;
    }

    public void setSAML2AttributeQueryCommented(boolean asComment) {
        this.saml2AttributeQueryCommented = asComment;
    }

    public void execute() {
        try {
            ClassPathResource resource = new ClassPathResource("net/shibboleth/idp/installer/metadata-generator.xml");
            Initializer initializer = new Initializer();
            GenericApplicationContext context = SpringSupport.newContext((String)MetadataGeneratorTask.class.getName(), Collections.singletonList(resource), Collections.emptyList(), Collections.emptyList(), Collections.singletonList(initializer), null);
            MetadataGeneratorParameters parameters = (MetadataGeneratorParameters)context.getBean("IdPConfiguration", MetadataGeneratorParameters.class);
            if (this.encryptionCert != null) {
                parameters.setEncryptionCert(this.encryptionCert);
            }
            if (this.signingCert != null) {
                parameters.setSigningCert(this.signingCert);
            }
            if (this.backchannelCert != null) {
                parameters.setBackchannelCert(this.backchannelCert);
            }
            MetadataGenerator generator = new MetadataGenerator(this.outputFile);
            ArrayList<List<String>> signing = new ArrayList<List<String>>(2);
            List<String> value = parameters.getBackchannelCert();
            if (null != value) {
                signing.add(value);
            }
            if (null != (value = parameters.getSigningCert())) {
                signing.add(value);
            }
            generator.setSigningCerts(signing);
            value = parameters.getEncryptionCert();
            if (null != value) {
                generator.setEncryptionCerts(Collections.singletonList(value));
            }
            if (this.dnsName != null) {
                generator.setDNSName(this.dnsName);
            } else {
                generator.setDNSName(parameters.getDnsName());
            }
            if (this.entityID != null) {
                generator.setEntityID(this.entityID);
            } else {
                generator.setEntityID(parameters.getEntityID());
            }
            if (this.scope != null) {
                generator.setScope(this.scope);
            } else {
                generator.setScope(parameters.getScope());
            }
            generator.setSAML2AttributeQueryCommented(this.isSAML2AttributeQueryCommented());
            generator.generate();
        }
        catch (Exception e) {
            this.log("Build failed", e, 0);
            throw new BuildException((Throwable)e);
        }
    }

    public class Initializer
    extends IdPPropertiesApplicationContextInitializer {
        @Nonnull
        public String[] getSearchLocations() {
            if (null == MetadataGeneratorTask.this.idpHome) {
                return super.getSearchLocations();
            }
            String[] result = new String[]{MetadataGeneratorTask.this.idpHome};
            return result;
        }
    }
}

