/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.installer.metadata;

import com.google.common.collect.ImmutableSet;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;

public class MetadataGenerator {
    static final ImmutableSet<Endpoints> BACKCHANNEL_ENDPOINTS = ImmutableSet.copyOf(EnumSet.of(Endpoints.SAML1Artifact, Endpoints.SAML2Artifact, Endpoints.SOAPSLO, Endpoints.SAML1Query, Endpoints.SAML2Query));
    static final ImmutableSet<Endpoints> ARTIFACT_ENDPOINTS = ImmutableSet.copyOf(EnumSet.of(Endpoints.SAML1Artifact, Endpoints.SAML2Artifact));
    static final ImmutableSet<Endpoints> SLO_ENDPOINTS = ImmutableSet.copyOf(EnumSet.of(Endpoints.ShibbolethSSO, Endpoints.POSTSSO, Endpoints.POSTSimpleSignSSO, Endpoints.RedirectSSO));
    static final ImmutableSet<Endpoints> SSO_ENDPOINTS = ImmutableSet.copyOf(EnumSet.of(Endpoints.RedirectSLO, Endpoints.POSTSLO, Endpoints.SOAPSLO));
    static final ImmutableSet<Endpoints> AA_ENDPOINTS = ImmutableSet.copyOf(EnumSet.of(Endpoints.SAML1Query, Endpoints.SAML2Query));
    private EnumSet<Endpoints> endpoints;
    private String entityID;
    private String dnsName;
    private String scope;
    private boolean saml2AttributeQueryCommented = true;
    private List<List<String>> signingCerts;
    private List<List<String>> encryptionCerts;
    private final BufferedWriter writer;

    public MetadataGenerator(@Nonnull File file) throws FileNotFoundException {
        File nonnullFile = (File)Constraint.isNotNull((Object)file, (String)"provided file must be nonnull");
        FileOutputStream outStream = new FileOutputStream(nonnullFile);
        this.writer = new BufferedWriter(new OutputStreamWriter(outStream));
        this.endpoints = EnumSet.allOf(Endpoints.class);
    }

    public String getEntityID() {
        return this.entityID;
    }

    public void setEntityID(String id) {
        this.entityID = id;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String id) {
        this.scope = id;
    }

    public String getDNSName() {
        return this.dnsName;
    }

    public void setDNSName(String id) {
        this.dnsName = id;
    }

    public List<List<String>> getSigningCerts() {
        return this.signingCerts;
    }

    public void setSigningCerts(List<List<String>> certs) {
        this.signingCerts = certs;
    }

    public List<List<String>> getEncryptionCerts() {
        return this.encryptionCerts;
    }

    public void setEncryptionCerts(List<List<String>> certs) {
        this.encryptionCerts = certs;
    }

    public void removeBackChannel() {
        this.endpoints.removeAll((Collection<?>)BACKCHANNEL_ENDPOINTS);
    }

    public EnumSet<Endpoints> getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(@Nonnull EnumSet<Endpoints> points) {
        this.endpoints = (EnumSet)Constraint.isNotNull(points, (String)"supplied endpoints should not be null");
    }

    public boolean isSAML2AttributeQueryCommented() {
        return this.saml2AttributeQueryCommented;
    }

    public void setSAML2AttributeQueryCommented(boolean asComment) {
        this.saml2AttributeQueryCommented = asComment;
    }

    public void generate() throws IOException {
        this.writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.writer.newLine();
        this.writeComments();
        this.writer.write("<");
        this.writer.write("EntityDescriptor");
        this.writer.write(32);
        this.writeNameSpace(null, "urn:oasis:names:tc:SAML:2.0:metadata");
        this.writeNameSpace("ds", "http://www.w3.org/2000/09/xmldsig#");
        this.writeNameSpace("shibmd", "urn:mace:shibboleth:metadata:1.0");
        this.writeNameSpace("xml", "http://www.w3.org/XML/1998/namespace");
        this.writeNameSpace("mdui", "urn:oasis:names:tc:SAML:metadata:ui");
        this.writer.write(" entityID=\"");
        this.writer.write(this.getEntityID());
        this.writer.write("\">");
        this.writer.newLine();
        this.writer.newLine();
        this.writeIDPSSO();
        this.writer.newLine();
        this.writer.newLine();
        this.writeAttributeAuthorityDescriptor();
        this.writer.newLine();
        this.writer.write("</EntityDescriptor>");
        this.writer.newLine();
        this.writer.flush();
        this.writer.close();
    }

    protected void writeComments() throws IOException {
        this.writer.write("<!--");
        this.writer.newLine();
        this.writer.write("     This is example metadata only. Do *NOT* supply it as is without review,");
        this.writer.newLine();
        this.writer.write("     and do *NOT* provide it in real time to your partners.");
        this.writer.newLine();
        this.writer.newLine();
        this.writer.write("     This metadata is not dynamic - it will not change as your configuration changes.");
        this.writer.newLine();
        this.writer.write("-->");
        this.writer.newLine();
    }

    protected void writeNameSpace(@Nullable String prefix, @Nonnull String name) throws IOException {
        this.writer.write(" xmlns");
        if (null != prefix) {
            this.writer.write(58);
            this.writer.write(prefix);
        }
        this.writer.write("=\"");
        this.writer.write(name);
        this.writer.write("\"");
    }

    protected void writeIDPSSO() throws IOException {
        this.writeRoleDescriptor("IDPSSODescriptor", Arrays.asList("urn:oasis:names:tc:SAML:2.0:protocol", "urn:oasis:names:tc:SAML:1.1:protocol", "urn:mace:shibboleth:1.0"));
        this.writer.newLine();
        this.writeExtensions();
        this.writer.newLine();
        this.writeKeyDescriptors();
        for (Endpoints endpoint : ARTIFACT_ENDPOINTS) {
            if (!this.getEndpoints().contains((Object)endpoint)) continue;
            this.outputEndpoint(endpoint);
        }
        this.writer.newLine();
        for (Endpoints endpoint : SLO_ENDPOINTS) {
            if (!this.getEndpoints().contains((Object)endpoint)) continue;
            this.outputEndpoint(endpoint);
        }
        this.writer.newLine();
        this.writeNameIdFormat("urn:mace:shibboleth:1.0:nameIdentifier");
        this.writeNameIdFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
        this.writer.newLine();
        for (Endpoints endpoint : SSO_ENDPOINTS) {
            if (!this.getEndpoints().contains((Object)endpoint)) continue;
            this.outputEndpoint(endpoint);
        }
        this.writer.newLine();
        this.writer.write("    </");
        this.writer.write("IDPSSODescriptor");
        this.writer.write(">");
        this.writer.newLine();
    }

    protected void writeNameIdFormat(String format) throws IOException {
        this.writer.write("        <");
        this.writer.write("NameIDFormat");
        this.writer.write(62);
        this.writer.write(format);
        this.writer.write("</");
        this.writer.write("NameIDFormat");
        this.writer.write(62);
        this.writer.newLine();
    }

    private void writeAttributeAuthorityDescriptor() throws IOException {
        this.writeRoleDescriptor("AttributeAuthorityDescriptor", Arrays.asList("urn:oasis:names:tc:SAML:2.0:protocol", "urn:oasis:names:tc:SAML:1.1:protocol"));
        this.writer.newLine();
        this.writeExtensions();
        this.writer.newLine();
        this.writeKeyDescriptors();
        for (Endpoints endpoint : AA_ENDPOINTS) {
            if (!this.getEndpoints().contains((Object)endpoint)) continue;
            this.outputEndpoint(endpoint);
        }
        this.writer.newLine();
        this.writer.write("    </");
        this.writer.write("AttributeAuthorityDescriptor");
        this.writer.write(62);
        this.writer.newLine();
    }

    protected void writeRoleDescriptor(String name, List<String> protocols) throws IOException {
        this.writer.write("    <");
        this.writer.write(name);
        this.writer.write(" protocolSupportEnumeration=\"");
        boolean first = true;
        for (String protocol : protocols) {
            if (!first) {
                this.writer.write(" ");
            }
            this.writer.write(protocol);
            first = false;
        }
        this.writer.write("\">");
        this.writer.newLine();
    }

    protected void writeExtensions() throws IOException {
        this.writer.write("        <");
        this.writer.write("Extensions");
        this.writer.write(62);
        this.writer.newLine();
        this.writeScope();
        this.writeMDUI();
        this.writer.write("        </");
        this.writer.write("Extensions");
        this.writer.write(62);
        this.writer.newLine();
    }

    protected void writeScope() throws IOException {
        if (null == this.getScope() || this.getScope().isEmpty()) {
            return;
        }
        this.writer.write("            <");
        this.writeNameSpaceQualified("shibmd", "Scope");
        this.writer.write(" regexp=\"false\">");
        this.writer.write(this.getScope());
        this.writer.write("</");
        this.writeNameSpaceQualified("shibmd", "Scope");
        this.writer.write(62);
        this.writer.newLine();
    }

    protected void writeMDUI() throws IOException {
        this.writer.write("<!--");
        this.writer.newLine();
        this.writer.write("    Fill in the details for your IdP here ");
        this.writer.newLine();
        this.writer.newLine();
        this.writer.write("            <");
        this.writeNameSpaceQualified("mdui", "UIInfo");
        this.writer.write(62);
        this.writer.newLine();
        this.writer.write("                <");
        this.writeNameSpaceQualified("mdui", "DisplayName");
        this.writer.write(32);
        this.writeLangAttribute("en");
        this.writer.write(62);
        this.writer.write("A Name for the IdP at ");
        this.writer.write(this.getDNSName());
        this.writer.write("</");
        this.writeNameSpaceQualified("mdui", "DisplayName");
        this.writer.write(62);
        this.writer.newLine();
        this.writer.write("                <");
        this.writeNameSpaceQualified("mdui", "Description");
        this.writer.write(32);
        this.writeLangAttribute("en");
        this.writer.write(62);
        this.writer.write("Enter a description of your IdP at ");
        this.writer.write(this.getDNSName());
        this.writer.write("</");
        this.writeNameSpaceQualified("mdui", "Description");
        this.writer.write(62);
        this.writer.newLine();
        this.writer.write("                <");
        this.writeNameSpaceQualified("mdui", "Logo");
        this.writer.write(" height=\"HeightInPixels\" width=\"WidthInPixels\">");
        this.writer.write("https://");
        this.writer.write(this.getDNSName());
        this.writer.write("/Path/To/Logo.png");
        this.writer.write("</");
        this.writeNameSpaceQualified("mdui", "Logo");
        this.writer.write(62);
        this.writer.newLine();
        this.writer.write("            </");
        this.writeNameSpaceQualified("mdui", "UIInfo");
        this.writer.write(62);
        this.writer.newLine();
        this.writer.write("-->");
        this.writer.newLine();
    }

    protected void writeLangAttribute(String language) throws IOException {
        this.writeNameSpaceQualified("xml", "lang");
        this.writer.write("=\"");
        this.writer.write(language);
        this.writer.write(34);
    }

    protected void writeKeyDescriptors() throws IOException {
        this.writeKeyDescriptors(this.getSigningCerts(), "signing");
        this.writeKeyDescriptors(this.getEncryptionCerts(), "encryption");
        this.writer.newLine();
    }

    protected void writeKeyDescriptors(@Nullable List<List<String>> certs, @Nonnull @NotEmpty String use) throws IOException {
        if (null == certs || certs.isEmpty()) {
            return;
        }
        for (List<String> cert : certs) {
            this.writer.write("        <");
            this.writer.write("KeyDescriptor");
            this.writer.write(" use=\"");
            this.writer.write(use);
            this.writer.write("\">");
            this.writer.newLine();
            this.writer.write("            <");
            this.writeNameSpaceQualified("ds", "KeyInfo");
            this.writer.write(62);
            this.writer.newLine();
            this.writer.write("                    <");
            this.writeNameSpaceQualified("ds", "X509Data");
            this.writer.write(62);
            this.writer.newLine();
            this.writer.write("                        <");
            this.writeNameSpaceQualified("ds", "X509Certificate");
            this.writer.write(62);
            this.writer.newLine();
            for (String certLine : cert) {
                this.writer.write(certLine);
                this.writer.newLine();
            }
            this.writer.write("                        </");
            this.writeNameSpaceQualified("ds", "X509Certificate");
            this.writer.write(62);
            this.writer.newLine();
            this.writer.write("                    </");
            this.writeNameSpaceQualified("ds", "X509Data");
            this.writer.write(62);
            this.writer.newLine();
            this.writer.write("            </");
            this.writeNameSpaceQualified("ds", "KeyInfo");
            this.writer.write(62);
            this.writer.newLine();
            this.writer.newLine();
            this.writer.write("        </");
            this.writer.write("KeyDescriptor");
            this.writer.write(62);
            this.writer.newLine();
        }
    }

    protected void outputEndpoint(Endpoints endpoint) throws IOException {
        switch (endpoint) {
            case SAML1Artifact: {
                this.writer.write("        ");
                this.writer.write("<");
                this.writer.write("ArtifactResolutionService");
                this.writer.write(" Binding=\"");
                this.writer.write("urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding");
                this.writer.write("\" Location=\"https://");
                this.writer.write(this.getDNSName());
                this.writer.write(":8443/idp/profile/SAML1/SOAP/ArtifactResolution\"");
                this.writer.write(" index=\"1\"/>");
                this.writer.newLine();
                break;
            }
            case SAML2Artifact: {
                this.writer.write("        ");
                this.writer.write("<");
                this.writer.write("ArtifactResolutionService");
                this.writer.write(" Binding=\"");
                this.writer.write("urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
                this.writer.write("\" Location=\"https://");
                this.writer.write(this.getDNSName());
                this.writer.write(":8443/idp/profile/SAML2/SOAP/ArtifactResolution\"");
                this.writer.write(" index=\"2\"/>");
                this.writer.newLine();
                break;
            }
            case RedirectSLO: {
                this.writer.write("        ");
                this.writer.write("<");
                this.writer.write("SingleLogoutService");
                this.writer.write(" Binding=\"");
                this.writer.write("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
                this.writer.write("\" Location=\"https://");
                this.writer.write(this.getDNSName());
                this.writer.write("/idp/profile/SAML2/Redirect/SLO\"/>");
                this.writer.newLine();
                break;
            }
            case POSTSLO: {
                this.writer.write("        ");
                this.writer.write("<");
                this.writer.write("SingleLogoutService");
                this.writer.write(" Binding=\"");
                this.writer.write("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
                this.writer.write("\" Location=\"https://");
                this.writer.write(this.getDNSName());
                this.writer.write("/idp/profile/SAML2/POST/SLO\"/>");
                this.writer.newLine();
                break;
            }
            case SOAPSLO: {
                this.writer.write("        ");
                this.writer.write("<");
                this.writer.write("SingleLogoutService");
                this.writer.write(" Binding=\"");
                this.writer.write("urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
                this.writer.write("\" Location=\"https://");
                this.writer.write(this.getDNSName());
                this.writer.write(":8443/idp/profile/SAML2/SOAP/SLO\"/>");
                this.writer.newLine();
                break;
            }
            case ShibbolethSSO: {
                this.writer.write("        ");
                this.writer.write("<");
                this.writer.write("SingleSignOnService");
                this.writer.write(" Binding=\"urn:mace:shibboleth:1.0:profiles:AuthnRequest\"");
                this.writer.write(" Location=\"https://");
                this.writer.write(this.getDNSName());
                this.writer.write("/idp/profile/Shibboleth/SSO\"/>");
                this.writer.newLine();
                break;
            }
            case POSTSSO: {
                this.writer.write("        ");
                this.writer.write("<");
                this.writer.write("SingleSignOnService");
                this.writer.write(" Binding=\"");
                this.writer.write("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
                this.writer.write("\" Location=\"https://");
                this.writer.write(this.getDNSName());
                this.writer.write("/idp/profile/SAML2/POST/SSO\"/>");
                this.writer.newLine();
                break;
            }
            case POSTSimpleSignSSO: {
                this.writer.write("        ");
                this.writer.write("<");
                this.writer.write("SingleSignOnService");
                this.writer.write(" Binding=\"");
                this.writer.write("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign");
                this.writer.write("\" Location=\"https://");
                this.writer.write(this.getDNSName());
                this.writer.write("/idp/profile/SAML2/POST/SSO-SimpleSign\"/>");
                this.writer.newLine();
                break;
            }
            case RedirectSSO: {
                this.writer.write("        ");
                this.writer.write("<");
                this.writer.write("SingleSignOnService");
                this.writer.write(" Binding=\"");
                this.writer.write("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
                this.writer.write("\" Location=\"https://");
                this.writer.write(this.getDNSName());
                this.writer.write("/idp/profile/SAML2/Redirect/SSO\"/>");
                this.writer.newLine();
                break;
            }
            case SAML1Query: {
                this.writer.write("        ");
                this.writer.write("<");
                this.writer.write("AttributeService");
                this.writer.write(" Binding=\"");
                this.writer.write("urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding");
                this.writer.write("\" Location=\"https://");
                this.writer.write(this.getDNSName());
                this.writer.write(":8443/idp/profile/SAML1/SOAP/AttributeQuery\"/>");
                this.writer.newLine();
                break;
            }
            case SAML2Query: {
                this.writer.write("        ");
                if (this.isSAML2AttributeQueryCommented()) {
                    this.writer.write("<!-- ");
                }
                this.writer.write("<");
                this.writer.write("AttributeService");
                this.writer.write(" Binding=\"");
                this.writer.write("urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
                this.writer.write("\" Location=\"https://");
                this.writer.write(this.getDNSName());
                this.writer.write(":8443/idp/profile/SAML2/SOAP/AttributeQuery\"/>");
                if (this.isSAML2AttributeQueryCommented()) {
                    this.writer.write(" -->");
                }
                this.writer.newLine();
                break;
            }
        }
    }

    protected void writeNameSpaceQualified(@Nonnull String nameSpace, String what) throws IOException {
        this.writer.write(nameSpace);
        this.writer.write(58);
        this.writer.write(what);
    }

    static enum Endpoints {
        SAML1Artifact,
        SAML2Artifact,
        RedirectSLO,
        POSTSLO,
        SOAPSLO,
        ShibbolethSSO,
        POSTSSO,
        POSTSimpleSignSSO,
        RedirectSSO,
        SAML1Query,
        SAML2Query;

    }
}

