/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.installer.metadata;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.springframework.core.io.Resource;

public class MetadataGeneratorParameters {
    private File encryptionCert;
    private File backChannelCert;
    private File signingCert;
    private String entityID;
    private String dnsName;
    private String scope;

    @Nullable
    public List<String> getEncryptionCert() throws IOException {
        return this.getCertificateContents(this.encryptionCert);
    }

    public void setEncryptionCert(File file) {
        this.encryptionCert = file;
    }

    public void setEncryptionCertResource(Resource resource) {
        try {
            this.encryptionCert = resource.getFile();
        }
        catch (IOException e) {
            this.encryptionCert = null;
        }
    }

    @Nullable
    public List<String> getSigningCert() throws IOException {
        return this.getCertificateContents(this.signingCert);
    }

    public void setSigningCert(File file) {
        this.signingCert = file;
    }

    public void setSigningCertResource(Resource resource) {
        try {
            this.signingCert = resource.getFile();
        }
        catch (IOException e) {
            this.signingCert = null;
        }
    }

    @Nullable
    public List<String> getBackchannelCert() throws IOException {
        return this.getCertificateContents(this.backChannelCert);
    }

    public void setBackchannelCert(File file) {
        this.backChannelCert = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getCertificateContents(File file) throws IOException {
        int last;
        if (null == file || !file.exists()) {
            return null;
        }
        FileReader fr = new FileReader(file);
        BufferedReader reader = new BufferedReader(fr);
        ArrayList<String> output = new ArrayList<String>();
        String s = reader.readLine();
        while (s != null) {
            output.add(s);
            s = reader.readLine();
        }
        if (output.size() > 0 && ((String)output.get(0)).startsWith("----")) {
            output.remove(0);
        }
        if ((last = output.size() - 1) <= 0) {
            List<String> list = null;
            return list;
        }
        if (((String)output.get(last)).startsWith("----")) {
            output.remove(last);
        }
        ArrayList<String> arrayList = output;
        return arrayList;
        finally {
            try {
                reader.close();
                fr.close();
            }
            catch (IOException e1) {}
        }
    }

    public String getEntityID() {
        return this.entityID;
    }

    public void setEntityID(String id) {
        this.entityID = id;
    }

    public String getDnsName() {
        return this.dnsName;
    }

    public void setDnsName(String name) {
        this.dnsName = name;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String value) {
        this.scope = value;
    }
}

