/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.installer;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;

public class ProgressReportingOutputStream
extends BufferedOutputStream {
    private static final int PROGRESS_EVERY = 65536;
    private int written;
    private boolean terminate;

    public ProgressReportingOutputStream(@Nonnull OutputStream outStream) {
        super(outStream);
    }

    public ProgressReportingOutputStream(@Nonnull OutputStream outStream, int size) {
        super(outStream, size);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        super.write(b, off, len);
        this.written += len;
        if (this.written > 65536) {
            if (System.out != null) {
                System.out.print('.');
                System.out.flush();
                this.terminate = true;
            }
            this.written -= 65536;
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.terminate) {
            System.out.println();
        }
    }
}

