/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.installer.impl;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import net.shibboleth.idp.Version;
import net.shibboleth.idp.installer.InstallerSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Jar;
import org.slf4j.Logger;

public final class BuildWar {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BuildWar.class);
    @Nonnull
    private final Path targetDir;

    public BuildWar(@Nonnull Path idpHome) {
        this.targetDir = (Path)Constraint.isNotNull((Object)idpHome, (String)"IdPHome should not be null");
        Constraint.isTrue((boolean)Files.exists(this.targetDir, new LinkOption[0]), (String)("Target Dir " + this.targetDir + " does not exist"));
    }

    private void overlayWebapp(@Nonnull Path from, @Nonnull Path webAppTo) throws BuildException {
        if (!Files.exists(from, new LinkOption[0])) {
            return;
        }
        Copy overlay = InstallerSupport.getCopyTask(from, webAppTo, "**/*.idpnew");
        overlay.setOverwrite(true);
        overlay.setPreserveLastModified(true);
        overlay.setFailOnError(true);
        overlay.setVerbose(this.log.isDebugEnabled());
        this.log.info("Overlay from {} to {}", (Object)from, (Object)webAppTo);
        overlay.execute();
    }

    public void execute() throws BuildException {
        Path warFile = this.targetDir.resolve("war").resolve("idp.war");
        this.log.info("Rebuilding {}, Version {}", (Object)warFile.toAbsolutePath(), (Object)Version.getVersion());
        InstallerSupport.deleteTree(this.targetDir.resolve("webpapp"));
        Path webAppTmp = this.targetDir.resolve("webpapp.tmp");
        InstallerSupport.deleteTree(webAppTmp);
        Path dist = this.targetDir.resolve("dist");
        Path distWebApp = dist.resolve("webapp");
        assert (distWebApp != null && webAppTmp != null);
        Copy initial = InstallerSupport.getCopyTask(distWebApp, webAppTmp);
        initial.setPreserveLastModified(true);
        initial.setFailOnError(true);
        initial.setVerbose(this.log.isDebugEnabled());
        this.log.info("Initial populate from {} to {}", (Object)distWebApp, (Object)webAppTmp);
        initial.execute();
        Path pluginWebapp = this.targetDir.resolve("dist").resolve("plugin-webapp");
        Path editWebapp = this.targetDir.resolve("edit-webapp");
        assert (pluginWebapp != null && editWebapp != null);
        this.overlayWebapp(pluginWebapp, webAppTmp);
        this.overlayWebapp(editWebapp, webAppTmp);
        File warFileFile = warFile.toFile();
        if (warFileFile.exists() && !warFile.toFile().delete()) {
            this.log.warn("Could not delete old war file: {}", (Object)warFile);
            this.log.warn("Fix and rerun the build command");
        }
        Jar jarTask = InstallerSupport.createJarTask(webAppTmp, warFile);
        this.log.info("Creating war file {}", (Object)warFile);
        jarTask.execute();
        InstallerSupport.deleteTree(webAppTmp);
    }
}

