/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.installer.impl;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.installer.impl.InstallerProperties;
import net.shibboleth.idp.module.IdPModule;
import net.shibboleth.profile.module.ModuleContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.apache.tools.ant.BuildException;
import org.slf4j.Logger;

public final class CurrentInstallState
extends AbstractInitializableComponent {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(CurrentInstallState.class);
    @Nonnull
    private final Path targetDir;
    @Nonnull
    private final String[][] deleteAfterUpgrades = new String[][]{{"credentials", "secrets.properties"}};
    @Nonnull
    private Set<String> enabledModules;
    private boolean idpPropertiesPresent;
    private boolean ldapPropertiesPresent;
    @Nullable
    private String oldVersion;
    @NonnullAfterInit
    private List<Path> pathsToDelete;
    @Nullable
    private ClassLoader installedPluginsLoader;

    public CurrentInstallState(InstallerProperties installerProps) {
        this.targetDir = installerProps.getTargetDir();
        this.enabledModules = CollectionSupport.emptySet();
    }

    private void findPreviousVersion() throws ComponentInitializationException {
        Path conf = this.targetDir.resolve("conf");
        Path currentInstall = this.targetDir.resolve("dist").resolve("idp.installed.version");
        Path ip = conf.resolve("idp.properties");
        if (!Files.exists(ip, new LinkOption[0])) {
            this.log.debug("No idp.properties file detetected at {} .  Inferring a clean install", (Object)ip);
            this.oldVersion = null;
        } else {
            if (!Files.exists(currentInstall, new LinkOption[0])) {
                throw new ComponentInitializationException("V3 Installation detected");
            }
            Properties vers = new Properties(1);
            try {
                vers.load(new FileInputStream(currentInstall.toFile()));
            }
            catch (IOException e) {
                LoggerFactory.getLogger(CurrentInstallState.class).error("Could not load {}", (Object)currentInstall.toAbsolutePath(), (Object)e);
                throw new ComponentInitializationException((Exception)e);
            }
            this.oldVersion = vers.getProperty("idp.installed.version");
            if (null == this.oldVersion) {
                LoggerFactory.getLogger(CurrentInstallState.class).error("Failed loading {}", (Object)currentInstall.toAbsolutePath());
                throw new ComponentInitializationException("File idp.installed.version did not contain property idp.installed.version");
            }
            this.log.debug("Previous version {}", (Object)this.oldVersion);
        }
    }

    private void findEnabledModules() throws IOException {
        if (this.getInstalledVersion() == null) {
            return;
        }
        String td = this.targetDir.toString();
        assert (td != null);
        ModuleContext moduleContext = new ModuleContext(td);
        this.enabledModules = new HashSet<String>();
        for (IdPModule module : ServiceLoader.load(IdPModule.class)) {
            if (module.isEnabled(moduleContext)) {
                this.log.debug("Detected enabled Module {}", (Object)module.getId());
                this.enabledModules.add(module.getId());
                continue;
            }
            this.log.debug("Detected disabled Module {}", (Object)module.getId());
        }
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        this.idpPropertiesPresent = Files.exists(this.targetDir.resolve("conf").resolve("idp.properties"), new LinkOption[0]);
        this.ldapPropertiesPresent = Files.exists(this.targetDir.resolve("conf").resolve("ldap.properties"), new LinkOption[0]);
        if (Files.exists(this.targetDir.resolve("system"), new LinkOption[0])) {
            this.log.error("'system' folder exists emove this and make appropriate changes to web.xml before proceeding");
            this.log.error("see https://shibboleth.atlassian.net/wiki/spaces/IDP5/pages/3199500925/Upgrading");
            throw new ComponentInitializationException("'systems folder exists");
        }
        this.findPreviousVersion();
        try {
            this.findEnabledModules();
        }
        catch (IOException | ServiceConfigurationError e) {
            this.log.error("Error loading modules", e);
        }
        if (null == this.getInstalledVersion()) {
            this.pathsToDelete = CollectionSupport.emptyList();
        } else {
            this.pathsToDelete = new ArrayList<Path>();
            for (int i = 0; i < this.deleteAfterUpgrades.length; ++i) {
                Path p = this.targetDir;
                String[] paths = this.deleteAfterUpgrades[i];
                for (int j = 0; j < paths.length; ++j) {
                    p = p.resolve(paths[j]);
                }
                if (Files.exists(p, new LinkOption[0])) continue;
                this.pathsToDelete.add(p);
            }
        }
    }

    @Nullable
    public String getInstalledVersion() {
        return this.oldVersion;
    }

    public boolean isIdPPropertiesPresent() {
        return this.idpPropertiesPresent;
    }

    public boolean isLDAPPropertiesPresent() {
        return this.ldapPropertiesPresent;
    }

    @Nonnull
    public List<Path> getPathsToBeDeleted() {
        assert (this.pathsToDelete != null);
        return this.pathsToDelete;
    }

    @Nonnull
    public Collection<String> getEnabledModules() {
        return this.enabledModules;
    }

    @Nullable
    public synchronized ClassLoader getInstalledPluginsLoader() {
        URL[] urls;
        if (this.installedPluginsLoader != null) {
            return this.installedPluginsLoader;
        }
        Path libs = this.targetDir.resolve("dist").resolve("plugin-webapp").resolve("WEB-INF").resolve("lib");
        if (Files.exists(libs, new LinkOption[0])) {
            try {
                final ArrayList copiedFiles = new ArrayList();
                SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        copiedFiles.add(file);
                        return FileVisitResult.CONTINUE;
                    }
                };
                try (DirectoryStream<Path> webInfLibs = Files.newDirectoryStream(libs);){
                    for (Path jar : webInfLibs) {
                        visitor.visitFile(jar, null);
                    }
                }
                urls = (URL[])copiedFiles.stream().map(path -> {
                    try {
                        return path.toUri().toURL();
                    }
                    catch (MalformedURLException e1) {
                        throw new BuildException((Throwable)e1);
                    }
                }).toArray(URL[]::new);
            }
            catch (IOException e) {
                this.log.error("Error finding Plugins' classpath", (Throwable)e);
                this.installedPluginsLoader = ((Object)((Object)this)).getClass().getClassLoader();
                return this.installedPluginsLoader;
            }
        }
        urls = new URL[]{};
        this.installedPluginsLoader = new URLClassLoader(urls);
        return this.installedPluginsLoader;
    }
}

