/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.installer.impl;

import com.beust.jcommander.Parameter;
import java.io.PrintStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.cli.AbstractCommandLineArguments;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class IdPInstallerArguments
extends AbstractCommandLineArguments {
    @Nullable
    private Logger log;
    @Parameter(names={"-s", "--sourceDir"})
    @Nullable
    private String sourceDir;
    @Parameter(names={"-t", "--targetDir"})
    @Nullable
    private String targetDir;
    @Parameter(names={"--noPrompt"})
    private boolean noPrompt;
    @Parameter(names={"-h", "--hostName"})
    private String hostName;
    @Parameter(names={"--scope"})
    private String scope;
    @Parameter(names={"-e", "--entityID"})
    private String entityID;
    @Parameter(names={"-kp", "--keystorePassword"})
    private String keystorePassword;
    @Parameter(names={"-sp", "--sealerPassword"})
    private String sealerPassword;
    @Parameter(names={"--propertyFile"})
    private String propertyFile;
    @Parameter(names={"-hc", "--http-client"})
    @Nullable
    @NotEmpty
    private String httpClientName;
    @Parameter(names={"-hs", "--http-security"})
    @Nullable
    @NotEmpty
    private String httpClientSecurityParametersName;

    @Nonnull
    public Logger getLog() {
        if (this.log == null) {
            this.log = LoggerFactory.getLogger(IdPInstallerArguments.class);
        }
        assert (this.log != null);
        return this.log;
    }

    public boolean isUnattended() {
        return this.noPrompt;
    }

    @Nullable
    public String getTargetDirectory() {
        return this.targetDir;
    }

    @Nullable
    public String getSourceDir() {
        return this.sourceDir;
    }

    @Nullable
    public String getPropertyFile() {
        return this.propertyFile;
    }

    @Nullable
    public String getHostName() {
        return this.hostName;
    }

    public String getScope() {
        return this.scope;
    }

    public String getEntityID() {
        return this.entityID;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public String getSealerPassword() {
        return this.sealerPassword;
    }

    @Nullable
    @NotEmpty
    public String getHttpClientName() {
        return this.httpClientName;
    }

    @Nullable
    @NotEmpty
    public String getHttpClientSecurityParametersName() {
        return this.httpClientSecurityParametersName;
    }

    public void printHelp(@Nonnull PrintStream out) {
        out.println("Install");
        out.println("Installs or upgrades an IdP");
        out.println();
        out.println(" Install [options] springConfiguration");
        out.println();
        out.println("      springConfiguration      name of Spring configuration resource to use");
        super.printHelp(out);
        out.println();
        out.println(String.format("  %-22s %s", "-t, --targetDir", "Where to install the IdP or location to update"));
        out.println(String.format("  %-22s %s", "--propertyFile", "Property file containing other parameterization"));
        out.println(String.format("  %-22s %s", "-h, --hostName", "DNS name for the IdP"));
        out.println(String.format("  %-22s %s", "-e, --entityID", "Entity ID for the IdP"));
        out.println(String.format("  %-22s %s", "-kp, --keystorePassword", "Password for the generated KeyStore"));
        out.println(String.format("  %-22s %s", "-sp, --sealerPassword", "Password for the generated Data Sealer"));
        out.println(String.format("  %-22s %s", "--noPrompt", "Unattended Install"));
        out.println(String.format("  %-22s %s", "-hc, --http-client", "Bean name for an http client (for Module and Plugin Operations"));
        out.println(String.format("  %-22s %s", "-hs, --http-securityt", "Bean name for http security parameters (for Module and Plugin Operations"));
        out.println();
    }
}

