/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.installer.impl;

import com.beust.jcommander.Parameter;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.Version;
import net.shibboleth.idp.cli.AbstractIdPHomeAwareCommandLineArguments;
import net.shibboleth.profile.installablecomponent.InstallableComponentVersion;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.slf4j.Logger;

public class UpdateIdPArguments
extends AbstractIdPHomeAwareCommandLineArguments {
    @Nullable
    private Logger log;
    @Parameter(names={"-l", "--list"})
    private boolean list;
    @Parameter(names={"-d", "--downloadDir"})
    @Nullable
    private String downloadDir;
    @Parameter(names={"--truststore"})
    @Nullable
    private String truststore;
    @Parameter(names={"-fd", "--forceDownload"})
    @Nullable
    private String forceDownloadVersion;
    @Parameter(names={"--updateURL"})
    @Nullable
    private String updateURL;
    @Parameter(names={"--pretendVersion"})
    @Nullable
    private String pretendVersion;
    @Nullable
    private InstallableComponentVersion updateVersion;
    @NonnullBeforeExec
    private InstallableComponentVersion fromVersion;
    @Nullable
    private Path downloadDirPath;
    @Nonnull
    private OperationType operation = OperationType.UNKNOWN;

    @Nonnull
    public Logger getLog() {
        if (this.log == null) {
            this.log = LoggerFactory.getLogger(UpdateIdPArguments.class);
        }
        assert (this.log != null);
        return this.log;
    }

    @Nullable
    public String getTruststore() {
        return this.truststore;
    }

    @Nonnull
    public Path getDownloadLocation() {
        Constraint.isTrue((this.operation == OperationType.DOWLOAD ? 1 : 0) != 0, (String)"Can only call getInputFileName on a ");
        assert (this.downloadDirPath != null);
        return this.downloadDirPath;
    }

    public boolean isList() {
        return this.list;
    }

    public boolean isCheck() {
        return !this.isList() && this.downloadDir == null;
    }

    @Nullable
    public InstallableComponentVersion getUpdateToVersion() {
        return this.updateVersion;
    }

    @Nonnull
    public InstallableComponentVersion getUpdateFromVersion() {
        assert (this.fromVersion != null);
        return this.fromVersion;
    }

    @Nonnull
    public List<String> getUpdateURLs() {
        String u = this.updateURL;
        if (u != null) {
            return CollectionSupport.singletonList((Object)u);
        }
        return CollectionSupport.emptyList();
    }

    @Nonnull
    public OperationType getOperation() {
        return this.operation;
    }

    public void validate() throws IllegalArgumentException {
        super.validate();
        try {
            if (StringSupport.trimOrNull((String)this.pretendVersion) != null) {
                this.fromVersion = new InstallableComponentVersion(this.pretendVersion);
            } else {
                String currentVersion = Version.getVersion();
                if (currentVersion == null) {
                    this.getLog().error("Could not determine current version.");
                    throw new IllegalArgumentException("Could not determine current version.");
                }
                this.fromVersion = new InstallableComponentVersion(currentVersion);
            }
            if (StringSupport.trimOrNull((String)this.forceDownloadVersion) != null) {
                this.updateVersion = new InstallableComponentVersion(this.forceDownloadVersion);
                if (this.downloadDir == null) {
                    this.getLog().error("Must specify a downloadDir if forceDownload is specified.");
                    throw new IllegalArgumentException("Must specify a downloadDir if forceDownload is specified.");
                }
            }
        }
        catch (NumberFormatException e) {
            this.getLog().error("Error in version specifier");
            throw new IllegalArgumentException("Error in version specifier", e);
        }
        if (this.list) {
            this.operation = OperationType.LIST;
            if (this.downloadDir != null) {
                this.getLog().error("Cannot List and Dowload in the same operation.");
                throw new IllegalArgumentException("Cannot List and Download in the same operation.");
            }
        } else if (this.downloadDir != null) {
            this.operation = OperationType.DOWLOAD;
            this.downloadDirPath = Path.of(this.downloadDir, new String[0]);
            if (!Files.exists(this.downloadDirPath, new LinkOption[0])) {
                this.getLog().error("Download directory {}, does not exist", (Object)this.downloadDir);
                throw new IllegalArgumentException("Download directory does not exist");
            }
            if (!Files.isDirectory(this.downloadDirPath, new LinkOption[0])) {
                this.getLog().error("Download location {}, exists, but is not a directory", (Object)this.downloadDir);
                throw new IllegalArgumentException("Download locaition is not a directory");
            }
        } else {
            this.operation = OperationType.CHECK;
        }
    }

    public void printHelp(@Nonnull PrintStream out) {
        out.println("Update");
        out.println("Provides a way of enquiring whether updates are available for the IdP");
        out.println();
        out.println("   update [options]");
        out.println();
        super.printHelp(out);
        out.println();
        out.println("With no options displays the update status of the IdP");
        out.println();
        out.println(String.format("  %-22s %s", "-d, --downloadDir <directory>", "Download the distribution for an available update"));
        out.println(String.format("  %-22s %s", "-fd, --force-download <file>", "Specify the version to be downloaded by -d"));
        out.println();
        out.println(String.format("  %-22s %s", "-l, --list", "list all available versions"));
        out.println();
        out.println(String.format("  %-22s %s", "--updateURL <URL>", "Explicit location to look for update information (overrides the default)"));
        out.println();
    }

    public static enum OperationType {
        DOWLOAD,
        LIST,
        CHECK,
        UNKNOWN;

    }
}

