/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.installer.impl;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.Version;
import net.shibboleth.idp.admin.impl.IdPInfo;
import net.shibboleth.idp.cli.AbstractIdPHomeAwareCommandLine;
import net.shibboleth.idp.cli.AbstractIdPHomeAwareCommandLineArguments;
import net.shibboleth.idp.installer.InstallerSupport;
import net.shibboleth.idp.installer.impl.UpdateIdPArguments;
import net.shibboleth.idp.installer.plugin.impl.TrustStore;
import net.shibboleth.profile.installablecomponent.InstallableComponentInfo;
import net.shibboleth.profile.installablecomponent.InstallableComponentSupport;
import net.shibboleth.profile.installablecomponent.InstallableComponentVersion;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.httpclient.HttpClientContextHandler;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.spring.httpclient.resource.HTTPResource;
import org.apache.commons.lang3.SystemUtils;
import org.apache.hc.client5.http.classic.HttpClient;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.opensaml.security.httpclient.HttpClientSecurityContextHandler;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.slf4j.Logger;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class UpdateIdPCLI
extends AbstractIdPHomeAwareCommandLine<UpdateIdPArguments> {
    @Nonnull
    public static final String SHIBBOLETH_SIGNING_KEYS = "http://shibboleth.net/downloads/PGP_KEYS";
    @Nullable
    private Logger log;

    @Nonnull
    protected Class<UpdateIdPArguments> getArgumentClass() {
        return UpdateIdPArguments.class;
    }

    @Nonnull
    protected String getVersion() {
        String result = Version.getVersion();
        assert (result != null);
        return result;
    }

    @Nonnull
    protected Logger getLogger() {
        Logger localLog = this.log;
        if (localLog == null) {
            localLog = this.log = LoggerFactory.getLogger(UpdateIdPCLI.class);
        }
        return localLog;
    }

    @Nonnull
    protected List<Resource> getAdditionalSpringResources() {
        return CollectionSupport.singletonList((Object)new ClassPathResource("net/shibboleth/idp/conf/http-client.xml"));
    }

    protected int doRun(@Nonnull UpdateIdPArguments args) {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        if (args.getHttpClientName() == null) {
            args.setHttpClientName("shibboleth.InternalHttpClient");
        }
        super.doRun((AbstractIdPHomeAwareCommandLineArguments)args);
        if (this.getHttpClient() == null) {
            this.getLogger().error("Could not not locate http client {}", (Object)args.getHttpClientName());
            return 1;
        }
        List urlStrings = args.getUpdateURLs().isEmpty() ? CollectionSupport.listOf((Object)"https://shibboleth.net/downloads/identity-provider/plugins/idp-versions.properties", (Object)"http://plugins.shibboleth.net/idp-versions.properties") : args.getUpdateURLs();
        ArrayList<URL> urls = new ArrayList<URL>(urlStrings.size());
        for (String s : urlStrings) {
            try {
                urls.add(new URL(s));
            }
            catch (MalformedURLException e) {
                this.getLogger().error("Could not convert {} to a URL", (Object)s);
                return 2;
            }
        }
        HttpClient client = this.getHttpClient();
        assert (client != null);
        Properties properties = InstallableComponentSupport.loadInfo(urls, (HttpClient)client, (HttpClientSecurityParameters)this.getHttpClientSecurityParameters());
        if (properties == null) {
            return 2;
        }
        IdPInfo info = new IdPInfo(properties);
        UpdateIdPArguments.OperationType operation = args.getOperation();
        if (operation == UpdateIdPArguments.OperationType.LIST) {
            return this.list(args, (InstallableComponentInfo)info);
        }
        return this.checkUpdate(args, (InstallableComponentInfo)info, operation == UpdateIdPArguments.OperationType.DOWLOAD);
    }

    private int checkUpdate(@Nonnull UpdateIdPArguments args, @Nonnull InstallableComponentInfo info, boolean doDownload) {
        boolean versionSpecified;
        InstallableComponentVersion from = args.getUpdateFromVersion();
        InstallableComponentInfo.VersionInfo currInfo = (InstallableComponentInfo.VersionInfo)info.getAvailableVersions().get(from);
        if (currInfo == null) {
            this.getLogger().warn("Could not locate version info for version {}", (Object)from);
        } else {
            InstallableComponentSupport.SupportLevel sl = currInfo.getSupportLevel();
            switch (sl) {
                case Current: {
                    this.getLogger().info("Version {} is current");
                    break;
                }
                case Secadv: {
                    this.getLogger().error("Version {} has known security vulnerabilities", (Object)from);
                    break;
                }
                default: {
                    this.getLogger().warn("Support level for {} is {}", (Object)from, (Object)sl);
                }
            }
        }
        InstallableComponentVersion newIdPVersion = args.getUpdateToVersion();
        boolean bl = versionSpecified = newIdPVersion != null;
        if (!versionSpecified) {
            newIdPVersion = InstallableComponentSupport.getBestVersion((InstallableComponentVersion)from, (InstallableComponentVersion)from, (InstallableComponentInfo)info);
        }
        if (newIdPVersion == null) {
            this.getLogger().info("No Upgrade available from {}", (Object)from);
            return 0;
        }
        if (versionSpecified) {
            this.getLogger().info("Download version {}", (Object)newIdPVersion);
        } else {
            this.getLogger().info("Version {} can be upgraded to {}", (Object)from, (Object)newIdPVersion);
        }
        if (!doDownload) {
            return 0;
        }
        InstallableComponentInfo.VersionInfo verInfo = (InstallableComponentInfo.VersionInfo)info.getAvailableVersions().get(newIdPVersion);
        assert (verInfo != null);
        return this.download(args, newIdPVersion, info);
    }

    private int list(@Nonnull UpdateIdPArguments args, @Nonnull InstallableComponentInfo info) {
        Map versionMap = info.getAvailableVersions();
        ArrayList versionList = new ArrayList(versionMap.keySet());
        versionList.sort(null);
        InstallableComponentVersion us = args.getUpdateFromVersion();
        for (InstallableComponentVersion ver : versionList) {
            InstallableComponentInfo.VersionInfo inf = (InstallableComponentInfo.VersionInfo)versionMap.get(ver);
            this.getLogger().info("Version {}{} Supported Status: {}, Upgrade Candidate: {}", new Object[]{ver, ver.equals((Object)us) ? " (current);" : ";", inf.getSupportLevel(), info.isSupportedWithIdPVersion(ver, us) ? "yes" : "no"});
        }
        return 0;
    }

    private int download(@Nonnull UpdateIdPArguments args, @Nonnull InstallableComponentVersion version, @Nonnull InstallableComponentInfo info) {
        String baseName = info.getUpdateBaseName(version);
        if (baseName == null) {
            this.getLogger().error("Could not get file name for idp update version {}", (Object)version);
            return 2;
        }
        String fileName = baseName + (SystemUtils.IS_OS_WINDOWS ? ".zip" : ".tgz");
        URL baseUrl = info.getUpdateURL(version);
        if (baseUrl == null) {
            this.getLogger().error("Could not get base URL for idp update version {}", (Object)version);
            return 2;
        }
        this.getLogger().info("Downloading version {} to {}  from {}/{}", new Object[]{version, args.getDownloadLocation(), baseUrl, fileName});
        try {
            HttpClient client = this.getHttpClient();
            assert (client != null);
            HTTPResource baseResource = new HTTPResource(client, baseUrl);
            HttpClientSecurityContextHandler handler = new HttpClientSecurityContextHandler();
            handler.setHttpClientSecurityParameters(this.getHttpClientSecurityParameters());
            handler.initialize();
            baseResource.setHttpClientContextHandler((HttpClientContextHandler)handler);
            InstallerSupport.download(baseResource, handler, args.getDownloadLocation(), fileName + ".asc");
            InstallerSupport.download(baseResource, handler, args.getDownloadLocation(), fileName);
        }
        catch (IOException | ComponentInitializationException e) {
            this.getLogger().error("Could not download idp version {} from {}", new Object[]{version, baseUrl, e});
            return 2;
        }
        this.getLogger().debug("Checking signature");
        int result = this.checkSignature(args, fileName);
        if (result != 0) {
            this.getLogger().info("Deleting downloaded files");
            try {
                Files.delete(args.getDownloadLocation().resolve(fileName));
                Files.delete(args.getDownloadLocation().resolve(fileName + ".asc"));
            }
            catch (IOException e) {
                this.getLogger().error("Could not delete {}[.asc]", (Object)fileName, (Object)e);
                args.getDownloadLocation().resolve(fileName).toFile().deleteOnExit();
                args.getDownloadLocation().resolve(fileName + ".asc").toFile().deleteOnExit();
            }
        } else {
            this.getLogger().info("Signature checked OK");
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int checkSignature(@Nonnull UpdateIdPArguments args, @Nonnull String fileName) {
        try (BufferedInputStream sigStream = new BufferedInputStream(new FileInputStream(args.getDownloadLocation().resolve(fileName + ".asc").toFile()));){
            TrustStore trust = new TrustStore();
            Path idpHome = Path.of(args.getIdPHome(), new String[0]);
            assert (idpHome != null);
            trust.setIdpHome(idpHome);
            trust.setTrustStore(args.getTruststore());
            trust.setPluginId("net.shibboleth.idp");
            trust.initialize();
            TrustStore.Signature sig = TrustStore.signatureOf(sigStream);
            if (!trust.contains(sig)) {
                this.getLogger().info("TrustStore does not contain signature {}", (Object)sig);
                this.getLogger().info("Downloading {}", (Object)SHIBBOLETH_SIGNING_KEYS);
                HttpClient client = this.getHttpClient();
                assert (client != null);
                HTTPResource baseResource = new HTTPResource(client, SHIBBOLETH_SIGNING_KEYS);
                HttpClientSecurityContextHandler handler = new HttpClientSecurityContextHandler();
                handler.setHttpClientSecurityParameters(this.getHttpClientSecurityParameters());
                handler.initialize();
                baseResource.setHttpClientContextHandler((HttpClientContextHandler)handler);
                try (BufferedInputStream keysStream = new BufferedInputStream(baseResource.getInputStream());){
                    trust.importKeyFromStream(sig, keysStream, new InstallerSupport.InstallerQuery("Accept this key"));
                }
                if (!trust.contains(sig)) {
                    this.getLogger().info("Key not added to Trust Store");
                    int n = 2;
                    return n;
                }
            }
            try (BufferedInputStream distroStream = new BufferedInputStream(new FileInputStream(args.getDownloadLocation().resolve(fileName).toFile()));){
                if (trust.checkSignature(distroStream, sig)) return 0;
                this.getLogger().info("Signature checked for {} failed", (Object)fileName);
                int n = 2;
                return n;
            }
        }
        catch (IOException | ComponentInitializationException e) {
            this.getLogger().error("Could not manage truststore for [{}, {}] ", new Object[]{args.getIdPHome(), "net.shibboleth.idp", e});
            return 2;
        }
    }

    public static int runMain(@Nonnull String[] args) {
        UpdateIdPCLI cli = new UpdateIdPCLI();
        return cli.run(args);
    }

    public static void main(@Nonnull String[] args) {
        System.exit(UpdateIdPCLI.runMain(args));
    }
}

