/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.installer.plugin.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public final class LoggingVisitor
extends SimpleFileVisitor<Path> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(LoggingVisitor.class);
    @Nonnull
    private final List<Path> copiedFiles = new ArrayList<Path>();
    @Nonnull
    private final Path from;
    @Nonnull
    private final Path to;

    public LoggingVisitor(@Nonnull Path fromDir, @Nonnull Path toDir) {
        this.from = fromDir;
        this.to = toDir;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        Path relDir = this.from.relativize(dir);
        Path toDir = this.to.resolve(relDir);
        if (!Files.exists(toDir, new LinkOption[0])) {
            this.log.trace("Creating directory {}", (Object)toDir);
            Files.createDirectory(toDir, new FileAttribute[0]);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        Path relFile = this.from.relativize(file);
        Path toFile = this.to.resolve(relFile);
        this.copiedFiles.add(toFile);
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file.toFile()));
             BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(toFile.toFile()));){
            ((InputStream)in).transferTo(out);
        }
        return FileVisitResult.CONTINUE;
    }

    @Nonnull
    public List<Path> getCopiedList() {
        return this.copiedFiles;
    }
}

