/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider;

import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.DataSetCore;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataprovider.StaticDataSetProvider;
import org.dashbuilder.dataprovider.StaticDataSetProviderCDI;
import org.dashbuilder.dataprovider.backend.elasticsearch.ElasticSearchDataSetProvider;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.events.DataSetDefModifiedEvent;
import org.dashbuilder.dataset.events.DataSetDefRemovedEvent;
import org.dashbuilder.dataset.events.DataSetStaleEvent;

@ApplicationScoped
public class ElasticSearchDataSetProviderCDI
extends ElasticSearchDataSetProvider {
    public ElasticSearchDataSetProviderCDI() {
    }

    @Inject
    public ElasticSearchDataSetProviderCDI(StaticDataSetProviderCDI staticDataSetProvider) {
        super((StaticDataSetProvider)staticDataSetProvider, DataSetCore.get().getIntervalBuilderLocator(), DataSetCore.get().getIntervalBuilderDynamicDate());
    }

    @PreDestroy
    public void destroy() {
        super.destroy();
    }

    private void onDataSetStaleEvent(@Observes DataSetStaleEvent event) {
        DataSetDef def = event.getDataSetDef();
        if (DataSetProviderType.ELASTICSEARCH.equals((Object)def.getProvider())) {
            this.remove(def.getUUID());
        }
    }

    private void onDataSetDefRemovedEvent(@Observes DataSetDefRemovedEvent event) {
        DataSetDef def = event.getDataSetDef();
        if (DataSetProviderType.ELASTICSEARCH.equals((Object)def.getProvider())) {
            this.remove(def.getUUID());
        }
    }

    private void onDataSetDefModifiedEvent(@Observes DataSetDefModifiedEvent event) {
        DataSetDef def = event.getOldDataSetDef();
        if (DataSetProviderType.ELASTICSEARCH.equals((Object)def.getProvider())) {
            this.remove(def.getUUID());
        }
    }
}

