/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataprovider.StaticDataSetProvider;
import org.dashbuilder.dataprovider.StaticDataSetProviderCDI;
import org.dashbuilder.dataprovider.kafka.KafkaDataSetProvider;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.events.DataSetDefModifiedEvent;
import org.dashbuilder.dataset.events.DataSetDefRemovedEvent;
import org.dashbuilder.dataset.events.DataSetStaleEvent;

@ApplicationScoped
public class KafkaDataSetProviderCDI
extends KafkaDataSetProvider {
    public KafkaDataSetProviderCDI() {
    }

    @Inject
    public KafkaDataSetProviderCDI(StaticDataSetProviderCDI staticDataSetProvider) {
        super((StaticDataSetProvider)staticDataSetProvider);
    }

    protected void onDataSetStaleEvent(@Observes DataSetStaleEvent event) {
        DataSetDef def = event.getDataSetDef();
        if (DataSetProviderType.KAFKA.equals((Object)def.getProvider())) {
            this.staticDataSetProvider.removeDataSet(def.getUUID());
        }
    }

    protected void onDataSetDefRemovedEvent(@Observes DataSetDefRemovedEvent event) {
        DataSetDef def = event.getDataSetDef();
        if (DataSetProviderType.KAFKA.equals((Object)def.getProvider())) {
            this.staticDataSetProvider.removeDataSet(def.getUUID());
        }
    }

    protected void onDataSetDefModifiedEvent(@Observes DataSetDefModifiedEvent event) {
        DataSetDef def = event.getOldDataSetDef();
        if (DataSetProviderType.KAFKA.equals((Object)def.getProvider())) {
            this.staticDataSetProvider.removeDataSet(def.getUUID());
        }
    }
}

