/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.client;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchRequest;
import org.hibernate.search.elasticsearch.client.impl.Paths;
import org.hibernate.search.elasticsearch.client.impl.URLEncodedString;
import org.hibernate.search.elasticsearch.impl.JsonBuilder;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.Assert;
import org.junit.Test;

public class RequestTest {
    @Test
    public void basicRequest() {
        JsonObject someJsonObject = JsonBuilder.object().addProperty("something", "encoded here").build();
        ElasticsearchRequest request = ElasticsearchRequest.post().pathComponent(Paths._BULK).param("refresh", false).param("quantity", 10).body(someJsonObject).build();
        Assert.assertEquals((Object)"POST", (Object)request.getMethod());
        Assert.assertEquals((long)2L, (long)request.getParameters().size());
        Assert.assertEquals((Object)"false", request.getParameters().get("refresh"));
        Assert.assertEquals((Object)"10", request.getParameters().get("quantity"));
        Assert.assertEquals((Object)("/" + Paths._BULK.original), (Object)request.getPath());
        Assert.assertEquals((long)1L, (long)request.getBodyParts().size());
        Assert.assertEquals((Object)someJsonObject, request.getBodyParts().get(0));
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2883")
    public void multiPathRequest() {
        ElasticsearchRequest request = ElasticsearchRequest.delete().pathComponent(Paths._BULK).pathComponent(Paths._SEARCH).build();
        Assert.assertEquals((Object)"DELETE", (Object)request.getMethod());
        Assert.assertEquals((long)0L, (long)request.getParameters().size());
        Assert.assertEquals((Object)("/" + Paths._BULK.original + "/" + Paths._SEARCH.original), (Object)request.getPath());
    }

    @Test
    public void multiValuedPathRequest() {
        ArrayList<URLEncodedString> typeNames = new ArrayList<URLEncodedString>(2);
        typeNames.add(URLEncodedString.fromString((String)"hello"));
        typeNames.add(URLEncodedString.fromString((String)"world"));
        ElasticsearchRequest request = ElasticsearchRequest.post().pathComponent(Paths._SEARCH).multiValuedPathComponent(typeNames).pathComponent(URLEncodedString.fromString((String)"nice day")).build();
        Assert.assertEquals((Object)"/_search/hello,world/nice+day", (Object)request.getPath());
    }
}

