/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.processor.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.hibernate.search.elasticsearch.processor.impl.ElasticsearchWorkBulker;
import org.hibernate.search.elasticsearch.processor.impl.ElasticsearchWorkSequenceBuilder;
import org.hibernate.search.elasticsearch.processor.impl.ParallelChangesetsElasticsearchWorkOrchestrator;
import org.hibernate.search.elasticsearch.work.impl.BulkableElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWorkAggregator;
import org.hibernate.search.test.util.FutureAssert;
import org.junit.Before;
import org.junit.Test;

public class ParallelChangesetsElasticsearchWorkOrchestratorTest {
    private ElasticsearchWorkSequenceBuilder sequenceBuilderMock;
    private ElasticsearchWorkBulker bulkerMock;
    private final List<Object> mocks = new ArrayList<Object>();

    @Before
    public void initMocks() {
        this.sequenceBuilderMock = (ElasticsearchWorkSequenceBuilder)EasyMock.createStrictMock(ElasticsearchWorkSequenceBuilder.class);
        this.mocks.add(this.sequenceBuilderMock);
        this.bulkerMock = (ElasticsearchWorkBulker)EasyMock.createStrictMock(ElasticsearchWorkBulker.class);
        this.mocks.add(this.bulkerMock);
    }

    @Test
    public void simple() {
        ElasticsearchWork<?> work1 = this.work(1);
        BulkableElasticsearchWork<?> work2 = this.bulkableWork(2);
        List<ElasticsearchWork> changeset1 = Arrays.asList(work1, work2);
        CompletableFuture<Object> sequenceFuture = new CompletableFuture<Object>();
        this.replay();
        ParallelChangesetsElasticsearchWorkOrchestrator orchestrator = new ParallelChangesetsElasticsearchWorkOrchestrator(this.sequenceBuilderMock, this.bulkerMock);
        this.verify();
        this.reset();
        this.sequenceBuilderMock.init((CompletableFuture)EasyMock.anyObject());
        work1.aggregate((ElasticsearchWorkAggregator)EasyMock.anyObject());
        EasyMock.expectLastCall().andAnswer(this.nonBulkableAggregateAnswer(work1));
        EasyMock.expect((Object)this.bulkerMock.flushBulked()).andReturn((Object)false);
        this.sequenceBuilderMock.addNonBulkExecution(work1);
        work2.aggregate((ElasticsearchWorkAggregator)EasyMock.anyObject());
        EasyMock.expectLastCall().andAnswer(this.bulkableAggregateAnswer(work2));
        this.bulkerMock.add(work2);
        EasyMock.expect((Object)this.bulkerMock.flushBulked()).andReturn((Object)true);
        EasyMock.expect((Object)this.sequenceBuilderMock.build()).andReturn(sequenceFuture);
        this.replay();
        CompletableFuture returnedSequenceFuture = orchestrator.submit(changeset1);
        this.verify();
        FutureAssert.assertThat((Future)returnedSequenceFuture).isSameAs(sequenceFuture);
        this.reset();
        this.bulkerMock.flushBulk();
        this.replay();
        CompletableFuture futureAll = orchestrator.flush();
        this.verify();
        FutureAssert.assertThat((Future)futureAll).isPending();
        sequenceFuture.complete(null);
        FutureAssert.assertThat((Future)futureAll).isSuccessful((Object)null);
    }

    @Test
    public void parallelSequenceBetweenChangeset() {
        ElasticsearchWork<?> work1 = this.work(1);
        List<ElasticsearchWork> changeset1 = Arrays.asList(work1);
        BulkableElasticsearchWork<?> work2 = this.bulkableWork(2);
        List<ElasticsearchWork> changeset2 = Arrays.asList(work2);
        CompletableFuture<Object> sequence1Future = new CompletableFuture<Object>();
        CompletableFuture<Object> sequence2Future = new CompletableFuture<Object>();
        this.replay();
        ParallelChangesetsElasticsearchWorkOrchestrator orchestrator = new ParallelChangesetsElasticsearchWorkOrchestrator(this.sequenceBuilderMock, this.bulkerMock);
        this.verify();
        this.reset();
        this.sequenceBuilderMock.init((CompletableFuture)EasyMock.anyObject());
        work1.aggregate((ElasticsearchWorkAggregator)EasyMock.anyObject());
        EasyMock.expectLastCall().andAnswer(this.nonBulkableAggregateAnswer(work1));
        EasyMock.expect((Object)this.bulkerMock.flushBulked()).andReturn((Object)false);
        this.sequenceBuilderMock.addNonBulkExecution(work1);
        EasyMock.expect((Object)this.bulkerMock.flushBulked()).andReturn((Object)false);
        EasyMock.expect((Object)this.sequenceBuilderMock.build()).andReturn(sequence1Future);
        this.replay();
        CompletableFuture returnedSequence1Future = orchestrator.submit(changeset1);
        this.verify();
        FutureAssert.assertThat((Future)returnedSequence1Future).isSameAs(sequence1Future);
        this.reset();
        this.sequenceBuilderMock.init((CompletableFuture)EasyMock.anyObject());
        work2.aggregate((ElasticsearchWorkAggregator)EasyMock.anyObject());
        EasyMock.expectLastCall().andAnswer(this.bulkableAggregateAnswer(work2));
        this.bulkerMock.add(work2);
        EasyMock.expect((Object)this.bulkerMock.flushBulked()).andReturn((Object)true);
        EasyMock.expect((Object)this.sequenceBuilderMock.build()).andReturn(sequence2Future);
        this.replay();
        CompletableFuture returnedSequence2Future = orchestrator.submit(changeset2);
        this.verify();
        FutureAssert.assertThat((Future)returnedSequence2Future).isSameAs(sequence2Future);
        this.reset();
        this.bulkerMock.flushBulk();
        this.replay();
        CompletableFuture futureAll = orchestrator.flush();
        this.verify();
        FutureAssert.assertThat((Future)futureAll).isPending();
        sequence2Future.complete(null);
        FutureAssert.assertThat((Future)futureAll).isPending();
        sequence1Future.complete(null);
        FutureAssert.assertThat((Future)futureAll).isSuccessful((Object)null);
    }

    @Test
    public void reuseBulkAccrossSequences() {
        BulkableElasticsearchWork<?> work1 = this.bulkableWork(1);
        List<ElasticsearchWork> changeset1 = Arrays.asList(work1);
        BulkableElasticsearchWork<?> work2 = this.bulkableWork(2);
        List<ElasticsearchWork> changeset2 = Arrays.asList(work2);
        CompletableFuture<Object> sequence1Future = new CompletableFuture<Object>();
        CompletableFuture<Object> sequence2Future = new CompletableFuture<Object>();
        this.replay();
        ParallelChangesetsElasticsearchWorkOrchestrator orchestrator = new ParallelChangesetsElasticsearchWorkOrchestrator(this.sequenceBuilderMock, this.bulkerMock);
        this.verify();
        this.reset();
        this.sequenceBuilderMock.init((CompletableFuture)EasyMock.anyObject());
        work1.aggregate((ElasticsearchWorkAggregator)EasyMock.anyObject());
        EasyMock.expectLastCall().andAnswer(this.bulkableAggregateAnswer(work1));
        this.bulkerMock.add(work1);
        EasyMock.expect((Object)this.bulkerMock.flushBulked()).andReturn((Object)true);
        EasyMock.expect((Object)this.sequenceBuilderMock.build()).andReturn(sequence1Future);
        this.replay();
        CompletableFuture returnedSequence1Future = orchestrator.submit(changeset1);
        this.verify();
        FutureAssert.assertThat((Future)returnedSequence1Future).isSameAs(sequence1Future);
        this.reset();
        this.sequenceBuilderMock.init((CompletableFuture)EasyMock.anyObject());
        work2.aggregate((ElasticsearchWorkAggregator)EasyMock.anyObject());
        EasyMock.expectLastCall().andAnswer(this.bulkableAggregateAnswer(work2));
        this.bulkerMock.add(work2);
        EasyMock.expect((Object)this.bulkerMock.flushBulked()).andReturn((Object)true);
        EasyMock.expect((Object)this.sequenceBuilderMock.build()).andReturn(sequence2Future);
        this.replay();
        CompletableFuture returnedSequence2Future = orchestrator.submit(changeset2);
        this.verify();
        FutureAssert.assertThat((Future)returnedSequence2Future).isSameAs(sequence2Future);
        this.reset();
        this.bulkerMock.flushBulk();
        this.replay();
        CompletableFuture futureAll = orchestrator.flush();
        this.verify();
        FutureAssert.assertThat((Future)futureAll).isPending();
        this.reset();
        this.replay();
        sequence2Future.complete(null);
        this.verify();
        FutureAssert.assertThat((Future)futureAll).isPending();
        this.reset();
        this.replay();
        sequence1Future.complete(null);
        this.verify();
        FutureAssert.assertThat((Future)futureAll).isSuccessful((Object)null);
    }

    @Test
    public void newBulkIfNonBulkable_sameChangeset() {
        BulkableElasticsearchWork<?> work1 = this.bulkableWork(1);
        ElasticsearchWork<?> work2 = this.work(2);
        BulkableElasticsearchWork<?> work3 = this.bulkableWork(3);
        List<ElasticsearchWork> changeset1 = Arrays.asList(work1, work2, work3);
        CompletableFuture<Object> sequence1Future = new CompletableFuture<Object>();
        this.replay();
        ParallelChangesetsElasticsearchWorkOrchestrator orchestrator = new ParallelChangesetsElasticsearchWorkOrchestrator(this.sequenceBuilderMock, this.bulkerMock);
        this.verify();
        this.reset();
        this.sequenceBuilderMock.init((CompletableFuture)EasyMock.anyObject());
        work1.aggregate((ElasticsearchWorkAggregator)EasyMock.anyObject());
        EasyMock.expectLastCall().andAnswer(this.bulkableAggregateAnswer(work1));
        this.bulkerMock.add(work1);
        work2.aggregate((ElasticsearchWorkAggregator)EasyMock.anyObject());
        EasyMock.expectLastCall().andAnswer(this.nonBulkableAggregateAnswer(work2));
        EasyMock.expect((Object)this.bulkerMock.flushBulked()).andReturn((Object)true);
        this.sequenceBuilderMock.addNonBulkExecution(work2);
        work3.aggregate((ElasticsearchWorkAggregator)EasyMock.anyObject());
        EasyMock.expectLastCall().andAnswer(this.bulkableAggregateAnswer(work3));
        this.bulkerMock.flushBulk();
        this.bulkerMock.add(work3);
        EasyMock.expect((Object)this.bulkerMock.flushBulked()).andReturn((Object)true);
        EasyMock.expect((Object)this.sequenceBuilderMock.build()).andReturn(sequence1Future);
        this.replay();
        CompletableFuture returnedSequence1Future = orchestrator.submit(changeset1);
        this.verify();
        FutureAssert.assertThat((Future)returnedSequence1Future).isSameAs(sequence1Future);
        this.reset();
        this.bulkerMock.flushBulk();
        this.replay();
        CompletableFuture futureAll = orchestrator.flush();
        this.verify();
        FutureAssert.assertThat((Future)futureAll).isPending();
        this.reset();
        this.replay();
        sequence1Future.complete(null);
        this.verify();
        FutureAssert.assertThat((Future)futureAll).isSuccessful((Object)null);
    }

    @Test
    public void newBulkIfNonBulkable_differenceChangesets() {
        BulkableElasticsearchWork<?> work1 = this.bulkableWork(1);
        List<ElasticsearchWork> changeset1 = Arrays.asList(work1);
        ElasticsearchWork<?> work2 = this.work(2);
        BulkableElasticsearchWork<?> work3 = this.bulkableWork(3);
        List<ElasticsearchWork> changeset2 = Arrays.asList(work2, work3);
        CompletableFuture<Object> sequence1Future = new CompletableFuture<Object>();
        CompletableFuture<Object> sequence2Future = new CompletableFuture<Object>();
        this.replay();
        ParallelChangesetsElasticsearchWorkOrchestrator orchestrator = new ParallelChangesetsElasticsearchWorkOrchestrator(this.sequenceBuilderMock, this.bulkerMock);
        this.verify();
        this.reset();
        this.sequenceBuilderMock.init((CompletableFuture)EasyMock.anyObject());
        work1.aggregate((ElasticsearchWorkAggregator)EasyMock.anyObject());
        EasyMock.expectLastCall().andAnswer(this.bulkableAggregateAnswer(work1));
        this.bulkerMock.add(work1);
        EasyMock.expect((Object)this.bulkerMock.flushBulked()).andReturn((Object)true);
        EasyMock.expect((Object)this.sequenceBuilderMock.build()).andReturn(sequence1Future);
        this.replay();
        CompletableFuture returnedSequence1Future = orchestrator.submit(changeset1);
        this.verify();
        FutureAssert.assertThat((Future)returnedSequence1Future).isSameAs(sequence1Future);
        this.reset();
        this.sequenceBuilderMock.init((CompletableFuture)EasyMock.anyObject());
        work2.aggregate((ElasticsearchWorkAggregator)EasyMock.anyObject());
        EasyMock.expectLastCall().andAnswer(this.nonBulkableAggregateAnswer(work2));
        EasyMock.expect((Object)this.bulkerMock.flushBulked()).andReturn((Object)true);
        this.sequenceBuilderMock.addNonBulkExecution(work2);
        work3.aggregate((ElasticsearchWorkAggregator)EasyMock.anyObject());
        EasyMock.expectLastCall().andAnswer(this.bulkableAggregateAnswer(work3));
        this.bulkerMock.flushBulk();
        this.bulkerMock.add(work3);
        EasyMock.expect((Object)this.bulkerMock.flushBulked()).andReturn((Object)false);
        EasyMock.expect((Object)this.sequenceBuilderMock.build()).andReturn(sequence2Future);
        this.replay();
        CompletableFuture returnedSequence2Future = orchestrator.submit(changeset2);
        this.verify();
        FutureAssert.assertThat((Future)returnedSequence2Future).isSameAs(sequence2Future);
        this.reset();
        this.bulkerMock.flushBulk();
        this.replay();
        CompletableFuture futureAll = orchestrator.flush();
        this.verify();
        FutureAssert.assertThat((Future)futureAll).isPending();
        this.reset();
        this.replay();
        sequence2Future.complete(null);
        this.verify();
        FutureAssert.assertThat((Future)futureAll).isPending();
        this.reset();
        this.replay();
        sequence1Future.complete(null);
        this.verify();
        FutureAssert.assertThat((Future)futureAll).isSuccessful((Object)null);
    }

    private void reset() {
        EasyMock.reset((Object[])this.mocks.toArray());
    }

    private void replay() {
        EasyMock.replay((Object[])this.mocks.toArray());
    }

    private void verify() {
        EasyMock.verify((Object[])this.mocks.toArray());
    }

    private ElasticsearchWork<?> work(int index) {
        ElasticsearchWork mock = (ElasticsearchWork)EasyMock.createStrictMock((String)("work" + index), ElasticsearchWork.class);
        this.mocks.add(mock);
        return mock;
    }

    private BulkableElasticsearchWork<?> bulkableWork(int index) {
        BulkableElasticsearchWork mock = (BulkableElasticsearchWork)EasyMock.createStrictMock((String)("bulkableWork" + index), BulkableElasticsearchWork.class);
        this.mocks.add(mock);
        return mock;
    }

    private IAnswer<Void> nonBulkableAggregateAnswer(ElasticsearchWork<?> mock) {
        return () -> {
            ElasticsearchWorkAggregator aggregator = (ElasticsearchWorkAggregator)EasyMock.getCurrentArguments()[0];
            aggregator.addNonBulkable(mock);
            return null;
        };
    }

    private IAnswer<Void> bulkableAggregateAnswer(BulkableElasticsearchWork<?> mock) {
        return () -> {
            ElasticsearchWorkAggregator aggregator = (ElasticsearchWorkAggregator)EasyMock.getCurrentArguments()[0];
            aggregator.addBulkable(mock);
            return null;
        };
    }
}

