/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.cfg;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public enum ElasticsearchIndexStatus {
    GREEN("green"),
    YELLOW("yellow"),
    RED("red");

    private static final Log LOG;
    private final String elasticsearchString;

    private ElasticsearchIndexStatus(String elasticsearchString) {
        this.elasticsearchString = elasticsearchString;
    }

    public String getElasticsearchString() {
        return this.elasticsearchString;
    }

    public static ElasticsearchIndexStatus fromString(String status) {
        for (ElasticsearchIndexStatus indexStatus : ElasticsearchIndexStatus.values()) {
            if (!indexStatus.getElasticsearchString().equalsIgnoreCase(status)) continue;
            return indexStatus;
        }
        throw LOG.unexpectedIndexStatusString(status);
    }

    static {
        LOG = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    }
}

