/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.query.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.search.Sort;
import org.hibernate.search.elasticsearch.client.impl.URLEncodedString;
import org.hibernate.search.elasticsearch.impl.ElasticsearchQueryOptions;
import org.hibernate.search.elasticsearch.impl.ElasticsearchService;
import org.hibernate.search.elasticsearch.impl.JsonBuilder;
import org.hibernate.search.elasticsearch.impl.ToElasticsearch;
import org.hibernate.search.elasticsearch.query.impl.QueryHitConverter;
import org.hibernate.search.elasticsearch.work.impl.ExplainResult;
import org.hibernate.search.elasticsearch.work.impl.SearchResult;
import org.hibernate.search.elasticsearch.work.impl.builder.SearchWorkBuilder;
import org.hibernate.search.engine.metadata.impl.FacetMetadata;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.query.facet.FacetingRequest;

class IndexSearcher {
    private static final int MAX_RESULT_WINDOW_SIZE = 10000;
    final ElasticsearchService elasticsearchService;
    private final Set<URLEncodedString> indexNames;
    private final Map<FacetingRequest, FacetMetadata> facetingRequestsAndMetadata;
    private final ElasticsearchQueryOptions queryOptions;
    private final QueryHitConverter queryHitConverter;
    private final JsonObject payload;

    public IndexSearcher(ElasticsearchService elasticsearchService, Map<String, EntityIndexBinding> targetedEntityBindingsByName, Set<URLEncodedString> indexNames, JsonObject filteredQuery, QueryHitConverter queryHitConverter, Sort sort, Map<FacetingRequest, FacetMetadata> facetingRequestsAndMetadata) {
        this.elasticsearchService = elasticsearchService;
        this.indexNames = indexNames;
        this.facetingRequestsAndMetadata = facetingRequestsAndMetadata;
        this.queryOptions = elasticsearchService.getQueryOptions();
        this.queryHitConverter = queryHitConverter;
        JsonBuilder.Object payloadBuilder = JsonBuilder.object();
        payloadBuilder.add("query", (JsonElement)filteredQuery);
        queryHitConverter.contributeToPayload(payloadBuilder);
        if (!facetingRequestsAndMetadata.isEmpty()) {
            JsonBuilder.Object facets = JsonBuilder.object();
            for (Map.Entry<FacetingRequest, FacetMetadata> facetingRequestEntry : facetingRequestsAndMetadata.entrySet()) {
                this.addFacetingRequest(facets, facetingRequestEntry.getKey(), facetingRequestEntry.getValue());
            }
            payloadBuilder.add("aggregations", facets);
        }
        if (sort != null) {
            payloadBuilder.add("sort", (JsonElement)ToElasticsearch.fromLuceneSort(sort));
        }
        this.payload = payloadBuilder.build();
    }

    public SearchResult search(int firstResult, Integer maxResults) {
        SearchWorkBuilder builder = this.elasticsearchService.getWorkFactory().search(this.payload).indexes(this.indexNames);
        builder.paging(firstResult, maxResults != null ? maxResults : 10000 - firstResult);
        Object work = builder.build();
        return (SearchResult)this.elasticsearchService.getWorkProcessor().executeSyncUnsafe(work);
    }

    public SearchResult searchWithScrollEnabled() {
        SearchWorkBuilder builder = this.elasticsearchService.getWorkFactory().search(this.payload).indexes(this.indexNames);
        builder.scrolling(this.getQueryOptions().getScrollFetchSize(), this.getQueryOptions().getScrollTimeout());
        Object work = builder.build();
        return (SearchResult)this.elasticsearchService.getWorkProcessor().executeSyncUnsafe(work);
    }

    public SearchResult scroll(String scrollId) {
        ElasticsearchQueryOptions queryOptions = this.getQueryOptions();
        Object work = this.elasticsearchService.getWorkFactory().scroll(scrollId, queryOptions.getScrollTimeout()).build();
        return (SearchResult)this.elasticsearchService.getWorkProcessor().executeSyncUnsafe(work);
    }

    public void clearScroll(String scrollId) {
        Object work = this.elasticsearchService.getWorkFactory().clearScroll(scrollId).build();
        this.elasticsearchService.getWorkProcessor().executeSyncUnsafe(work);
    }

    public EntityInfo convertQueryHit(SearchResult searchResult, JsonObject hit) {
        return this.queryHitConverter.convert(searchResult, hit);
    }

    public ExplainResult explain(JsonObject hit) {
        JsonObject explainPayload = JsonBuilder.object().add("query", this.payload.get("query")).build();
        Object work = this.elasticsearchService.getWorkFactory().explain(URLEncodedString.fromJSon(hit.get("_index")), URLEncodedString.fromJSon(hit.get("_type")), URLEncodedString.fromJSon(hit.get("_id")), explainPayload).build();
        return (ExplainResult)this.elasticsearchService.getWorkProcessor().executeSyncUnsafe(work);
    }

    public ElasticsearchQueryOptions getQueryOptions() {
        return this.queryOptions;
    }

    public Map<FacetingRequest, FacetMetadata> getFacetingRequestsAndMetadata() {
        return this.facetingRequestsAndMetadata;
    }

    private void addFacetingRequest(JsonBuilder.Object facets, FacetingRequest facetingRequest, FacetMetadata facetMetadata) {
        String sourceFieldAbsoluteName = facetMetadata.getSourceField().getAbsoluteName();
        String facetSubfieldName = facetMetadata.getPath().getRelativeName();
        ToElasticsearch.addFacetingRequest(facets, facetingRequest, sourceFieldAbsoluteName, facetSubfieldName);
    }
}

