/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.query.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FloatField;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.bridge.spi.ConversionContext;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.query.impl.FieldProjection;
import org.hibernate.search.elasticsearch.util.impl.FieldHelper;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.util.logging.impl.LoggerFactory;

class PrimitiveProjection
extends FieldProjection {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final TypeMetadata rootTypeMetadata;
    private final String absoluteName;
    private final FieldHelper.ExtendedFieldType fieldType;

    public PrimitiveProjection(TypeMetadata rootTypeMetadata, String absoluteName, FieldHelper.ExtendedFieldType fieldType) {
        this.rootTypeMetadata = rootTypeMetadata;
        this.absoluteName = absoluteName;
        this.fieldType = fieldType;
    }

    public void addDocumentField(Document tmp, JsonObject hit, ConversionContext conversionContext) {
        JsonElement jsonValue = this.extractFieldValue(hit.get("_source").getAsJsonObject(), this.absoluteName);
        this.addDocumentField(tmp, jsonValue);
    }

    public void addDocumentField(Document tmp, JsonElement jsonValue) {
        if (jsonValue == null || jsonValue.isJsonNull()) {
            return;
        }
        switch (this.fieldType) {
            case INTEGER: {
                tmp.add((IndexableField)new IntField(this.absoluteName, jsonValue.getAsInt(), Field.Store.NO));
                break;
            }
            case LONG: {
                tmp.add((IndexableField)new LongField(this.absoluteName, jsonValue.getAsLong(), Field.Store.NO));
                break;
            }
            case FLOAT: {
                tmp.add((IndexableField)new FloatField(this.absoluteName, jsonValue.getAsFloat(), Field.Store.NO));
                break;
            }
            case DOUBLE: {
                tmp.add((IndexableField)new DoubleField(this.absoluteName, jsonValue.getAsDouble(), Field.Store.NO));
                break;
            }
            case UNKNOWN_NUMERIC: {
                throw LOG.unexpectedNumericEncodingType(this.rootTypeMetadata.getType(), this.absoluteName);
            }
            case BOOLEAN: {
                tmp.add((IndexableField)new StringField(this.absoluteName, String.valueOf(jsonValue.getAsBoolean()), Field.Store.NO));
                break;
            }
            default: {
                tmp.add((IndexableField)new StringField(this.absoluteName, jsonValue.getAsString(), Field.Store.NO));
            }
        }
    }

    @Override
    public Object convertHit(JsonObject hit, ConversionContext conversionContext) {
        JsonElement jsonValue = this.extractFieldValue(hit.get("_source").getAsJsonObject(), this.absoluteName);
        if (jsonValue == null || jsonValue.isJsonNull()) {
            return null;
        }
        switch (this.fieldType) {
            case INTEGER: {
                return jsonValue.getAsInt();
            }
            case LONG: {
                return jsonValue.getAsLong();
            }
            case FLOAT: {
                return Float.valueOf(jsonValue.getAsFloat());
            }
            case DOUBLE: {
                return jsonValue.getAsDouble();
            }
            case UNKNOWN_NUMERIC: {
                throw LOG.unexpectedNumericEncodingType(this.rootTypeMetadata.getType(), this.absoluteName);
            }
            case BOOLEAN: {
                return jsonValue.getAsBoolean();
            }
        }
        return jsonValue.getAsString();
    }
}

