/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.elasticsearch.testutil.JsonHelper;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.TermMatchingContext;
import org.hibernate.search.test.SearchTestBase;
import org.junit.Test;

public class ElasticsearchDSLIT
extends SearchTestBase {
    @Test
    public void testDSLMatchAll() throws Exception {
        try (Session session = this.openSession();){
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            QueryBuilder queryBuilder = this.queryBuilder(fullTextSession);
            Query query = queryBuilder.all().createQuery();
            FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(query, new Class[]{Letter.class});
            String queryString = fullTextQuery.getQueryString();
            JsonHelper.assertJsonEquals("{'query':{'match_all':{}}}", queryString);
        }
    }

    @Test
    public void testDSLPhrase() throws Exception {
        try (Session session = this.openSession();){
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            QueryBuilder queryBuilder = this.queryBuilder(fullTextSession);
            Query query = queryBuilder.phrase().withSlop(2).onField("message").sentence("A very important matter").createQuery();
            FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(query, new Class[]{Letter.class});
            String queryString = fullTextQuery.getQueryString();
            JsonHelper.assertJsonEquals("{'query':{'match_phrase':{'message':{'query':'A very important matter','analyzer':'english','slop':2,'boost':1.0}}}}", queryString);
        }
    }

    @Test
    public void testDSLKeywordIgnoringAnalyzer() throws Exception {
        try (Session session = this.openSession();){
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            QueryBuilder queryBuilder = this.queryBuilder(fullTextSession);
            Query query = ((TermMatchingContext)queryBuilder.keyword().onField("message").ignoreAnalyzer()).matching((Object)"A very important matter").createQuery();
            FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(query, new Class[]{Letter.class});
            String queryString = fullTextQuery.getQueryString();
            JsonHelper.assertJsonEquals("{'query':{'term':{'message':{'value':'A very important matter','boost':1.0}}}}", queryString);
        }
    }

    @Test
    public void testDSLKeyword() throws Exception {
        try (Session session = this.openSession();){
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            QueryBuilder queryBuilder = this.queryBuilder(fullTextSession);
            Query query = queryBuilder.keyword().onField("message").matching((Object)"A very important matter").createQuery();
            FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(query, new Class[]{Letter.class});
            String queryString = fullTextQuery.getQueryString();
            JsonHelper.assertJsonEquals("{'query':{'match':{'message':{'query':'A very important matter','analyzer':'english','fuzziness':0,'boost':1.0}}}}", queryString);
        }
    }

    @Test
    public void testDSLPhraseQueryWithoutAnalyzer() {
        try (Session session = this.openSession();){
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            QueryBuilder queryBuilder = this.queryBuilder(fullTextSession);
            Query query = queryBuilder.phrase().onField("signature").sentence("Gunnar Morling").createQuery();
            FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(query, new Class[]{Letter.class});
            String queryString = fullTextQuery.getQueryString();
            JsonHelper.assertJsonEquals("{'query':{'match_phrase':{'signature':{'query':'Gunnar Morling','analyzer':'default','slop':0,'boost':1.0}}}}", queryString);
        }
    }

    private QueryBuilder queryBuilder(FullTextSession fullTextSession) {
        QueryBuilder tweetQueryBuilder = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Letter.class).get();
        return tweetQueryBuilder;
    }

    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Letter.class};
    }

    @Entity
    @Indexed
    public static class Letter {
        @Id
        @GeneratedValue
        private Integer id;
        @Field
        @Analyzer(definition="english")
        private String message;
        @Field
        private String signature;

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getSignature() {
            return this.signature;
        }

        public void setSignature(String signature) {
            this.signature = signature;
        }
    }
}

