/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.testutil;

import io.searchbox.action.Action;
import io.searchbox.core.Count;
import io.searchbox.core.CountResult;
import java.util.ArrayList;
import org.hibernate.search.elasticsearch.client.impl.JestClient;
import org.hibernate.search.elasticsearch.impl.ElasticsearchIndexManager;
import org.hibernate.search.elasticsearch.impl.IndexNameNormalizer;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.service.spi.ServiceReference;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.test.TestResourceManager;
import org.hibernate.search.test.util.BackendTestHelper;

public class ElasticsearchBackendTestHelper
extends BackendTestHelper {
    private TestResourceManager resourceManager;

    public ElasticsearchBackendTestHelper(TestResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public int getNumberOfDocumentsInIndex(Class<?> entityType) {
        ServiceManager serviceManager = this.resourceManager.getExtendedSearchIntegrator().getServiceManager();
        IndexManager[] indexManagers = this.resourceManager.getExtendedSearchIntegrator().getIndexBinding(entityType).getIndexManagers();
        ArrayList<String> indexNames = new ArrayList<String>(indexManagers.length);
        for (IndexManager indexManager : indexManagers) {
            indexNames.add(((ElasticsearchIndexManager)indexManager).getActualIndexName());
        }
        try (ServiceReference client = serviceManager.requestReference(JestClient.class);){
            Count request = ((Count.Builder)((Count.Builder)new Count.Builder().addIndex(indexNames)).addType(entityType.getName())).build();
            CountResult response = (CountResult)((JestClient)client.get()).executeRequest((Action)request, new int[0]);
            int n = response.getCount().intValue();
            return n;
        }
    }

    public int getNumberOfDocumentsInIndex(String indexName) {
        ServiceManager serviceManager = this.resourceManager.getExtendedSearchIntegrator().getServiceManager();
        try (ServiceReference client = serviceManager.requestReference(JestClient.class);){
            Count request = ((Count.Builder)new Count.Builder().addIndex(IndexNameNormalizer.getElasticsearchIndexName((String)indexName))).build();
            CountResult response = (CountResult)((JestClient)client.get()).executeRequest((Action)request, new int[0]);
            int n = response.getCount().intValue();
            return n;
        }
    }

    public int getNumberOfDocumentsInIndexByQuery(String indexName, String fieldName, String value) {
        ServiceManager serviceManager = this.resourceManager.getExtendedSearchIntegrator().getServiceManager();
        String query = value.contains("*") ? "wildcard" : "term";
        try (ServiceReference client = serviceManager.requestReference(JestClient.class);){
            Count request = ((Count.Builder)new Count.Builder().addIndex(IndexNameNormalizer.getElasticsearchIndexName((String)indexName))).query("{ \"query\" : { \"" + query + "\" : { \"" + fieldName + "\" : \"" + value + "\" } } }").build();
            CountResult response = (CountResult)((JestClient)client.get()).executeRequest((Action)request, new int[0]);
            int n = response.getCount().intValue();
            return n;
        }
    }
}

