/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.client.impl;

import com.google.gson.JsonElement;
import io.searchbox.action.Action;
import io.searchbox.action.BulkableAction;
import io.searchbox.action.DocumentTargetedAction;
import io.searchbox.client.JestClientFactory;
import io.searchbox.client.JestResult;
import io.searchbox.client.config.HttpClientConfig;
import io.searchbox.core.Bulk;
import io.searchbox.core.BulkResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.hibernate.search.elasticsearch.client.impl.BackendRequest;
import org.hibernate.search.elasticsearch.impl.GsonHolder;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.engine.service.spi.Service;
import org.hibernate.search.engine.service.spi.Startable;
import org.hibernate.search.engine.service.spi.Stoppable;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class JestClient
implements Service,
Startable,
Stoppable {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);
    private static final int TIME_OUT = 408;
    private static final String SERVER_URI_PROP_PREFIX = "hibernate.search.default.";
    private io.searchbox.client.JestClient client;

    public void start(Properties properties, BuildContext context) {
        JestClientFactory factory = new JestClientFactory();
        String serverUri = ConfigurationParseHelper.getString((Properties)properties, (String)"hibernate.search.default.elasticsearch.host", (String)"http://localhost:9200");
        factory.setHttpClientConfig(((HttpClientConfig.Builder)((HttpClientConfig.Builder)((HttpClientConfig.Builder)((HttpClientConfig.Builder)new HttpClientConfig.Builder(serverUri).multiThreaded(true)).readTimeout(60000)).connTimeout(2000)).gson(GsonHolder.GSON)).build());
        this.client = factory.getObject();
    }

    public void stop() {
        this.client.shutdownClient();
    }

    public <T extends JestResult> T executeRequest(Action<T> request, int ... ignoredErrorStatuses) {
        return this.executeRequest(request, this.asSet(ignoredErrorStatuses));
    }

    public <T extends JestResult> T executeRequest(Action<T> request, Set<Integer> ignoredErrorStatuses) {
        try {
            JestResult result = this.client.execute(request);
            if (!result.isSucceeded() && !this.isIgnored(result.getResponseCode(), ignoredErrorStatuses)) {
                if (result.getResponseCode() == 408) {
                    throw LOG.elasticsearchRequestTimeout(this.requestToString(request), this.resultToString(result));
                }
                throw LOG.elasticsearchRequestFailed(this.requestToString(request), this.resultToString(result), null);
            }
            return (T)result;
        }
        catch (IOException e) {
            throw LOG.elasticsearchRequestFailed(this.requestToString(request), null, e);
        }
    }

    public void executeBulkRequest(List<BackendRequest<?>> actions, boolean refresh) {
        Bulk.Builder bulkBuilder = (Bulk.Builder)new Bulk.Builder().setParameter("refresh", (Object)refresh);
        for (BackendRequest<?> action : actions) {
            bulkBuilder.addAction((BulkableAction)action.getAction());
        }
        Bulk request = bulkBuilder.build();
        try {
            BulkResult response = (BulkResult)this.client.execute((Action)request);
            List<BackendRequest<? extends JestResult>> erroneousItems = this.getErroneousItems(actions, response);
            if (!erroneousItems.isEmpty()) {
                throw LOG.elasticsearchBulkRequestFailed(this.requestToString((Action<?>)request), this.resultToString((JestResult)response), erroneousItems);
            }
        }
        catch (IOException e) {
            throw LOG.elasticsearchRequestFailed(this.requestToString((Action<?>)request), null, e);
        }
    }

    private List<BackendRequest<?>> getErroneousItems(List<BackendRequest<?>> actions, BulkResult response) {
        int i = 0;
        ArrayList erroneousItems = new ArrayList();
        for (BulkResult.BulkResultItem resultItem : response.getItems()) {
            BackendRequest<?> action;
            if (!(resultItem.error == null && resultItem.status < 400 || (action = actions.get(i)).getIgnoredErrorStatuses().contains(resultItem.status))) {
                erroneousItems.add(action);
            }
            ++i;
        }
        return erroneousItems;
    }

    private boolean isIgnored(int responseCode, Set<Integer> ignoredStatuses) {
        if (ignoredStatuses == null) {
            return true;
        }
        return ignoredStatuses.contains(responseCode);
    }

    private Set<Integer> asSet(int ... ignoredErrorStatuses) {
        Set<Integer> ignored;
        if (ignoredErrorStatuses == null || ignoredErrorStatuses.length == 0) {
            ignored = Collections.emptySet();
        } else if (ignoredErrorStatuses.length == 1) {
            ignored = Collections.singleton(ignoredErrorStatuses[0]);
        } else {
            ignored = new HashSet<Integer>();
            for (int ignoredErrorStatus : ignoredErrorStatuses) {
                ignored.add(ignoredErrorStatus);
            }
        }
        return ignored;
    }

    private String requestToString(Action<?> action) {
        StringBuilder sb = new StringBuilder();
        sb.append("Operation: ").append(action.getClass().getSimpleName()).append("\n");
        if (action instanceof DocumentTargetedAction) {
            sb.append("Index: ").append(((DocumentTargetedAction)action).getIndex()).append("\n");
            sb.append("Type: ").append(((DocumentTargetedAction)action).getType()).append("\n");
            sb.append("Id: ").append(((DocumentTargetedAction)action).getId()).append("\n");
        }
        sb.append("Data:\n");
        sb.append(action.getData(GsonHolder.GSON));
        sb.append("\n");
        return sb.toString();
    }

    private String resultToString(JestResult result) {
        StringBuilder sb = new StringBuilder();
        sb.append("Status: ").append(result.getResponseCode()).append("\n");
        sb.append("Error message: ").append(result.getErrorMessage()).append("\n");
        sb.append("Cluster name: ").append(this.property(result, "cluster_name")).append("\n");
        sb.append("Cluster status: ").append(this.property(result, "status")).append("\n");
        sb.append("\n");
        if (result instanceof BulkResult) {
            for (BulkResult.BulkResultItem item : ((BulkResult)result).getItems()) {
                sb.append("Operation: ").append(item.operation).append("\n");
                sb.append("  Index: ").append(item.index).append("\n");
                sb.append("  Type: ").append(item.type).append("\n");
                sb.append("  Id: ").append(item.id).append("\n");
                sb.append("  Status: ").append(item.status).append("\n");
                sb.append("  Error: ").append(item.error).append("\n");
            }
        }
        return sb.toString();
    }

    private String property(JestResult result, String name) {
        if (result.getJsonObject() == null) {
            return null;
        }
        JsonElement clusterName = result.getJsonObject().get(name);
        if (clusterName == null) {
            return null;
        }
        return clusterName.getAsString();
    }
}

