/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.client.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.elasticsearch.client.impl.BackendRequest;
import org.hibernate.search.elasticsearch.client.impl.BulkRequestFailedException;
import org.hibernate.search.elasticsearch.client.impl.ExecutableRequest;
import org.hibernate.search.elasticsearch.client.impl.JestClient;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.exception.impl.ErrorContextBuilder;

public class BulkRequest
implements ExecutableRequest {
    private final JestClient jestClient;
    private final ErrorHandler errorHandler;
    private final List<BackendRequest<?>> requests;
    private final boolean refresh;
    private final Set<String> indexNames;
    private final Set<String> indexesNeedingRefresh;

    public BulkRequest(JestClient jestClient, ErrorHandler errorHandler, List<BackendRequest<?>> requests, Set<String> indexNames, Set<String> indexesNeedingRefresh, boolean refresh) {
        this.jestClient = jestClient;
        this.errorHandler = errorHandler;
        this.requests = requests;
        this.indexNames = indexNames;
        this.indexesNeedingRefresh = indexesNeedingRefresh;
        this.refresh = refresh;
    }

    @Override
    public void execute() {
        try {
            this.jestClient.executeBulkRequest(this.requests, this.refresh);
        }
        catch (BulkRequestFailedException brfe) {
            ErrorContextBuilder builder = new ErrorContextBuilder();
            ArrayList<LuceneWork> allWork = new ArrayList<LuceneWork>();
            for (BackendRequest<?> backendRequest : this.requests) {
                allWork.add(backendRequest.getLuceneWork());
                if (brfe.getErroneousItems().contains(backendRequest)) continue;
                builder.workCompleted(backendRequest.getLuceneWork());
            }
            builder.allWorkToBeDone(allWork);
            for (BackendRequest<?> failedAction : brfe.getErroneousItems()) {
                builder.addWorkThatFailed(failedAction.getLuceneWork());
            }
            builder.errorThatOccurred((Throwable)((Object)brfe));
            this.errorHandler.handle(builder.createErrorContext());
        }
        catch (Exception e) {
            this.errorHandler.handleException("Bulk request failed", (Throwable)e);
        }
    }

    @Override
    public Set<String> getTouchedIndexes() {
        return this.indexNames;
    }

    @Override
    public Set<String> getIndexesNeedingRefresh() {
        if (this.refresh) {
            return Collections.emptySet();
        }
        return this.indexesNeedingRefresh;
    }

    @Override
    public int getSize() {
        return this.requests.size();
    }

    public String toString() {
        return "BulkRequest [size=" + this.requests.size() + ", refresh=" + this.refresh + ", indexNames=" + this.indexNames + ", indexesNeedingRefresh=" + this.indexesNeedingRefresh + "]";
    }
}

