/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.impl;

import java.lang.reflect.AnnotatedElement;
import java.util.Calendar;
import java.util.Date;
import org.hibernate.search.annotations.DateBridge;
import org.hibernate.search.annotations.Resolution;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.impl.ExtendedBridgeProvider;
import org.hibernate.search.bridge.spi.IndexManagerTypeSpecificBridgeProvider;
import org.hibernate.search.elasticsearch.impl.ElasticsearchCalendarBridge;
import org.hibernate.search.elasticsearch.impl.ElasticsearchDateBridge;
import org.hibernate.search.elasticsearch.spi.ElasticsearchIndexManagerType;
import org.hibernate.search.indexes.spi.IndexManagerType;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ElasticsearchBridgeProvider
extends ExtendedBridgeProvider
implements IndexManagerTypeSpecificBridgeProvider {
    private static final Log LOG = LoggerFactory.make();

    public IndexManagerType getIndexManagerType() {
        return ElasticsearchIndexManagerType.INSTANCE;
    }

    public FieldBridge provideFieldBridge(ExtendedBridgeProvider.ExtendedBridgeProviderContext context) {
        AnnotatedElement annotatedElement = context.getAnnotatedElement();
        if (Date.class.isAssignableFrom(context.getReturnType())) {
            Resolution resolution = this.getResolution(annotatedElement);
            return this.getDateFieldBridge(resolution);
        }
        if (Calendar.class.isAssignableFrom(context.getReturnType())) {
            Resolution resolution = this.getResolution(annotatedElement);
            return this.getCalendarFieldBridge(resolution);
        }
        return null;
    }

    private Resolution getResolution(AnnotatedElement annotatedElement) {
        if (annotatedElement.isAnnotationPresent(DateBridge.class)) {
            return annotatedElement.getAnnotation(DateBridge.class).resolution();
        }
        return Resolution.MILLISECOND;
    }

    private FieldBridge getDateFieldBridge(Resolution resolution) {
        switch (resolution) {
            case YEAR: {
                return ElasticsearchDateBridge.DATE_YEAR;
            }
            case MONTH: {
                return ElasticsearchDateBridge.DATE_MONTH;
            }
            case DAY: {
                return ElasticsearchDateBridge.DATE_DAY;
            }
            case HOUR: {
                return ElasticsearchDateBridge.DATE_HOUR;
            }
            case MINUTE: {
                return ElasticsearchDateBridge.DATE_MINUTE;
            }
            case SECOND: {
                return ElasticsearchDateBridge.DATE_SECOND;
            }
            case MILLISECOND: {
                return ElasticsearchDateBridge.DATE_MILLISECOND;
            }
        }
        throw LOG.unknownResolution(resolution.toString());
    }

    private FieldBridge getCalendarFieldBridge(Resolution resolution) {
        switch (resolution) {
            case YEAR: {
                return ElasticsearchCalendarBridge.DATE_YEAR;
            }
            case MONTH: {
                return ElasticsearchCalendarBridge.DATE_MONTH;
            }
            case DAY: {
                return ElasticsearchCalendarBridge.DATE_DAY;
            }
            case HOUR: {
                return ElasticsearchCalendarBridge.DATE_HOUR;
            }
            case MINUTE: {
                return ElasticsearchCalendarBridge.DATE_MINUTE;
            }
            case SECOND: {
                return ElasticsearchCalendarBridge.DATE_SECOND;
            }
            case MILLISECOND: {
                return ElasticsearchCalendarBridge.DATE_MILLISECOND;
            }
        }
        throw LOG.unknownResolution(resolution.toString());
    }
}

