/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.fest.assertions.Assertions;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.DateBridge;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Resolution;
import org.hibernate.search.annotations.SortableField;
import org.hibernate.search.elasticsearch.testutil.JsonHelper;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.TermMatchingContext;
import org.hibernate.search.test.SearchTestBase;
import org.junit.Test;

public class ElasticsearchDSLIT
extends SearchTestBase {
    @Test
    public void testDSLMatchAll() throws Exception {
        try (Session session = this.openSession();){
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            QueryBuilder queryBuilder = this.queryBuilder(fullTextSession);
            Query query = queryBuilder.all().createQuery();
            FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(query, new Class[]{Letter.class});
            String queryString = fullTextQuery.getQueryString();
            JsonHelper.assertJsonEquals("{'query':{'match_all':{}}}", queryString);
        }
    }

    @Test
    public void testDSLPhrase() throws Exception {
        try (Session session = this.openSession();){
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            QueryBuilder queryBuilder = this.queryBuilder(fullTextSession);
            Query query = queryBuilder.phrase().withSlop(2).onField("message").sentence("A very important matter").createQuery();
            FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(query, new Class[]{Letter.class});
            String queryString = fullTextQuery.getQueryString();
            JsonHelper.assertJsonEquals("{'query':{'match_phrase':{'message':{'query':'A very important matter','slop':2,'analyzer':'english'}}}}", queryString);
        }
    }

    @Test
    public void testDSLKeywordIgnoringAnalyzer() throws Exception {
        try (Session session = this.openSession();){
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            QueryBuilder queryBuilder = this.queryBuilder(fullTextSession);
            Query query = ((TermMatchingContext)queryBuilder.keyword().onField("message").ignoreAnalyzer()).matching((Object)"A very important matter").createQuery();
            FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(query, new Class[]{Letter.class});
            String queryString = fullTextQuery.getQueryString();
            JsonHelper.assertJsonEquals("{'query':{'term':{'message':{'value':'A very important matter'}}}}", queryString);
        }
    }

    @Test
    public void testDSLKeyword() throws Exception {
        try (Session session = this.openSession();){
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            QueryBuilder queryBuilder = this.queryBuilder(fullTextSession);
            Query query = queryBuilder.keyword().onField("message").matching((Object)"A very important matter").createQuery();
            FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(query, new Class[]{Letter.class});
            String queryString = fullTextQuery.getQueryString();
            JsonHelper.assertJsonEquals("{'query':{'match':{'message':{'query':'A very important matter','analyzer':'english'}}}}", queryString);
        }
    }

    @Test
    public void testDSLKeywordWithFuzziness() throws Exception {
        try (Session session = this.openSession();){
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            QueryBuilder queryBuilder = this.queryBuilder(fullTextSession);
            Query query = queryBuilder.keyword().fuzzy().withEditDistanceUpTo(2).onField("message").matching((Object)"A very important matter").createQuery();
            FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(query, new Class[]{Letter.class});
            String queryString = fullTextQuery.getQueryString();
            JsonHelper.assertJsonEquals("{'query':{'match':{'message':{'query':'A very important matter','analyzer':'english','fuzziness':2}}}}", queryString);
        }
    }

    @Test
    public void testDSLKeywordWithBoost() throws Exception {
        try (Session session = this.openSession();){
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            QueryBuilder queryBuilder = this.queryBuilder(fullTextSession);
            Query query = ((TermMatchingContext)queryBuilder.keyword().onField("message").boostedTo(2.0f)).matching((Object)"A very important matter").createQuery();
            FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(query, new Class[]{Letter.class});
            String queryString = fullTextQuery.getQueryString();
            JsonHelper.assertJsonEquals("{'query':{'match':{'message':{'query':'A very important matter','analyzer':'english','boost':2.0}}}}", queryString);
        }
    }

    @Test
    public void testDSLKeywordBoolean() throws Exception {
        try (Session session = this.openSession();){
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            QueryBuilder queryBuilder = this.queryBuilder(fullTextSession);
            Query query = queryBuilder.keyword().onField("personal").matching((Object)true).createQuery();
            FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(query, new Class[]{Letter.class});
            String queryString = fullTextQuery.getQueryString();
            JsonHelper.assertJsonEquals("{'query':{'term':{'personal':{'value':'true'}}}}", queryString);
        }
    }

    @Test
    public void testDSLKeywordFloat() throws Exception {
        try (Session session = this.openSession();){
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            QueryBuilder queryBuilder = this.queryBuilder(fullTextSession);
            Query query = queryBuilder.keyword().onField("shippingCost").matching((Object)Float.valueOf(0.4f)).createQuery();
            FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(query, new Class[]{Letter.class});
            String queryString = fullTextQuery.getQueryString();
            JsonHelper.assertJsonEquals("{'query':{'range':{'shippingCost':{'gte':0.4,'lte':0.4}}}}", queryString);
        }
    }

    @Test
    public void testDSLKeywordDate() throws Exception {
        try (Session session = this.openSession();){
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            QueryBuilder queryBuilder = this.queryBuilder(fullTextSession);
            Calendar date = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.ENGLISH);
            date.set(1958, 3, 7, 5, 5, 5);
            date.set(14, 0);
            Query query = queryBuilder.keyword().onField("dateWritten").matching((Object)date.getTime()).createQuery();
            FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(query, new Class[]{Letter.class});
            String queryString = fullTextQuery.getQueryString();
            JsonHelper.assertJsonEquals("{'query':{'term':{'dateWritten':{'value':'1958-04-07T00:00:00Z'}}}}", queryString);
        }
    }

    @Test
    public void testDSLKeywordCalendar() throws Exception {
        try (Session session = this.openSession();){
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            QueryBuilder queryBuilder = this.queryBuilder(fullTextSession);
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.ENGLISH);
            calendar.set(1958, 3, 7, 5, 5, 5);
            calendar.set(14, 0);
            Query query = queryBuilder.keyword().onField("dateSent").matching((Object)calendar).createQuery();
            FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(query, new Class[]{Letter.class});
            String queryString = fullTextQuery.getQueryString();
            JsonHelper.assertJsonEquals("{'query':{'term':{'dateSent':{'value':'1958-04-07T00:00:00Z'}}}}", queryString);
        }
    }

    @Test
    public void testDSLPhraseQueryWithoutAnalyzer() {
        try (Session session = this.openSession();){
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            QueryBuilder queryBuilder = this.queryBuilder(fullTextSession);
            Query query = queryBuilder.phrase().onField("signature").sentence("Gunnar Morling").createQuery();
            FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(query, new Class[]{Letter.class});
            String queryString = fullTextQuery.getQueryString();
            JsonHelper.assertJsonEquals("{'query':{'match_phrase':{'signature':{'query':'Gunnar Morling','analyzer':'default'}}}}", queryString);
        }
    }

    @Test
    public void testDSLSortNativeSimpleString() {
        try (Session session = this.openSession();){
            Letter letter1 = new Letter();
            Letter letter2 = new Letter();
            this.persist(session, letter1);
            this.persist(session, letter2);
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            QueryBuilder queryBuilder = this.queryBuilder(fullTextSession);
            Query query = queryBuilder.all().createQuery();
            FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(query, new Class[]{Letter.class});
            Sort sort = queryBuilder.sort().byNative("idSort", "\"desc\"").createSort();
            fullTextQuery.setSort(sort);
            List list = fullTextQuery.list();
            Assertions.assertThat((List)list).onProperty("id").containsExactly(new Object[]{letter2.getId(), letter1.getId()});
            fullTextQuery = fullTextSession.createFullTextQuery(query, new Class[]{Letter.class});
            sort = queryBuilder.sort().byNative("idSort", "\"asc\"").createSort();
            fullTextQuery.setSort(sort);
            list = fullTextQuery.list();
            Assertions.assertThat((List)list).onProperty("id").containsExactly(new Object[]{letter1.getId(), letter2.getId()});
        }
    }

    @Test
    public void testDSLSortNativeMap() {
        try (Session session = this.openSession();){
            Letter letter1 = new Letter();
            Letter letter2 = new Letter();
            this.persist(session, letter1);
            this.persist(session, letter2);
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            QueryBuilder queryBuilder = this.queryBuilder(fullTextSession);
            Query query = queryBuilder.all().createQuery();
            FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(query, new Class[]{Letter.class});
            Sort sort = queryBuilder.sort().byNative("idSort", "{\"order\":\"desc\"}").createSort();
            fullTextQuery.setSort(sort);
            List list = fullTextQuery.list();
            Assertions.assertThat((List)list).onProperty("id").containsExactly(new Object[]{letter2.getId(), letter1.getId()});
            fullTextQuery = fullTextSession.createFullTextQuery(query, new Class[]{Letter.class});
            sort = queryBuilder.sort().byNative("idSort", "{\"order\":\"asc\"}").createSort();
            fullTextQuery.setSort(sort);
            list = fullTextQuery.list();
            Assertions.assertThat((List)list).onProperty("id").containsExactly(new Object[]{letter1.getId(), letter2.getId()});
        }
    }

    private QueryBuilder queryBuilder(FullTextSession fullTextSession) {
        QueryBuilder tweetQueryBuilder = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Letter.class).get();
        return tweetQueryBuilder;
    }

    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Letter.class};
    }

    private void persist(Session session, Letter letter) {
        Transaction tx = session.beginTransaction();
        session.persist((Object)letter);
        tx.commit();
        session.clear();
    }

    @Entity
    @Indexed
    public static class Letter {
        @Id
        @GeneratedValue
        @Field(name="idSort")
        @SortableField(forField="idSort")
        private Integer id;
        @Field
        @Analyzer(definition="english")
        private String message;
        @Field
        private String signature;
        @Field
        @DateBridge(resolution=Resolution.DAY)
        private Date dateWritten;
        @Field
        @DateBridge(resolution=Resolution.DAY)
        private Calendar dateSent;
        @Field
        private boolean personal;
        @Field
        private float shippingCost;

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getSignature() {
            return this.signature;
        }

        public void setSignature(String signature) {
            this.signature = signature;
        }

        public Date getDateWritten() {
            return this.dateWritten;
        }

        public void setDateWritten(Date dateWritten) {
            this.dateWritten = dateWritten;
        }

        public Calendar getDateSent() {
            return this.dateSent;
        }

        public void setDateSent(Calendar dateSent) {
            this.dateSent = dateSent;
        }
    }
}

