/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.elasticsearch.ElasticsearchQueries;
import org.hibernate.search.elasticsearch.test.GolfCourse;
import org.hibernate.search.elasticsearch.test.GolfPlayer;
import org.hibernate.search.elasticsearch.test.Hole;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.engine.spi.QueryDescriptor;
import org.hibernate.search.test.SearchTestBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ElasticsearchDateCalendarBridgeIT
extends SearchTestBase {
    @Before
    public void setupTestData() {
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        Calendar dob = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.ENGLISH);
        dob.set(1958, 3, 7, 5, 5, 5);
        dob.set(14, 0);
        Calendar subscriptionEndDate = GregorianCalendar.getInstance(TimeZone.getTimeZone("Europe/Paris"), Locale.FRENCH);
        subscriptionEndDate.set(2016, 5, 7, 4, 4, 4);
        GolfPlayer hergesheimer = new GolfPlayer.Builder().firstName("Klaus").lastName("Hergesheimer").active(true).dateOfBirth(dob.getTime()).subscriptionEndDate(subscriptionEndDate).handicap(3.4).driveWidth(285).ranking(311).build();
        s.persist((Object)hergesheimer);
        GolfPlayer kidd = new GolfPlayer.Builder().lastName("Kidd").build();
        s.persist((Object)kidd);
        tx.commit();
        s.close();
    }

    @After
    public void deleteTestData() {
        Session s = this.openSession();
        FullTextSession session = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        QueryDescriptor query = ElasticsearchQueries.fromJson((String)"{ 'query': { 'match_all' : {} } }");
        List result = session.createFullTextQuery(query, new Class[0]).list();
        for (Object entity : result) {
            session.delete(entity);
        }
        tx.commit();
        s.close();
    }

    @Test
    public void testDateResolution() {
        Session s = this.openSession();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        Calendar dob = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.ENGLISH);
        dob.set(1958, 3, 7, 7, 7, 7);
        QueryBuilder monthQb = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(GolfPlayer.class).get();
        Query query = monthQb.keyword().onField("dateOfBirth").matching((Object)dob.getTime()).createQuery();
        Assert.assertEquals((long)1L, (long)fullTextSession.createFullTextQuery(query, new Class[]{GolfPlayer.class}).getResultSize());
        tx.commit();
        s.close();
    }

    @Test
    public void testCalendarResolution() {
        Session s = this.openSession();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        Calendar subscriptionEndDate = GregorianCalendar.getInstance(TimeZone.getTimeZone("Europe/Paris"), Locale.FRENCH);
        subscriptionEndDate.set(2016, 5, 7, 7, 7, 7);
        QueryBuilder monthQb = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(GolfPlayer.class).get();
        Query query = monthQb.keyword().onField("subscriptionEndDate").matching((Object)subscriptionEndDate).createQuery();
        Assert.assertEquals((long)1L, (long)fullTextSession.createFullTextQuery(query, new Class[]{GolfPlayer.class}).getResultSize());
        tx.commit();
        s.close();
    }

    @Test
    public void testProjectionOfCalendarValueRetrievesCorrectTimeZoneOffset() {
        Session s = this.openSession();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        Calendar subscriptionEndDate = GregorianCalendar.getInstance(TimeZone.getTimeZone("Europe/Paris"), Locale.FRENCH);
        subscriptionEndDate.set(2016, 5, 7, 7, 7, 7);
        QueryBuilder monthQb = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(GolfPlayer.class).get();
        Query query = monthQb.keyword().onField("subscriptionEndDate").matching((Object)subscriptionEndDate).createQuery();
        List results = fullTextSession.createFullTextQuery(query, new Class[]{GolfPlayer.class}).setProjection(new String[]{"subscriptionEndDate"}).list();
        Assert.assertEquals((long)1L, (long)results.size());
        Date now = new Date();
        Assert.assertEquals((long)TimeZone.getTimeZone("Europe/Paris").getOffset(now.getTime()), (long)((Calendar)((Object[])results.iterator().next())[0]).getTimeZone().getOffset(now.getTime()));
        tx.commit();
        s.close();
    }

    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{GolfPlayer.class, GolfCourse.class, Hole.class};
    }
}

