/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.Id;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.elasticsearch.cfg.IndexSchemaManagementStrategy;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.test.DefaultTestResourceManager;
import org.hibernate.search.test.util.TestConfiguration;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;

@RunWith(value=Suite.class)
@Suite.SuiteClasses(value={BooleanFailureTest.class, DateFailureTest.class})
public class ElasticsearchIndexNullAsTypeCheckingIT {

    public static class DateFailureTest
    extends AbstractIndexNullAsFailureTest {
        @Test
        public void indexNullAs_invalid_boolean() {
            this.thrown.expect(SearchException.class);
            this.thrown.expectMessage("HSEARCH400028");
            this.thrown.expectMessage("Date");
            this.thrown.expectMessage("myField");
            this.init();
        }

        public Class<?>[] getAnnotatedClasses() {
            return new Class[]{DateFailureTestEntity.class};
        }

        @Indexed
        @Entity
        public static class DateFailureTestEntity {
            @DocumentId
            @Id
            Long id;
            @Field(indexNullAs="01/01/2013")
            Date myField;
        }
    }

    public static class BooleanFailureTest
    extends AbstractIndexNullAsFailureTest {
        @Test
        public void indexNullAs_invalid_boolean() {
            this.thrown.expect(SearchException.class);
            this.thrown.expectMessage("HSEARCH400027");
            this.thrown.expectMessage("Boolean");
            this.thrown.expectMessage("myField");
            this.init();
        }

        public Class<?>[] getAnnotatedClasses() {
            return new Class[]{BooleanFailureTestEntity.class};
        }

        @Indexed
        @Entity
        public static class BooleanFailureTestEntity {
            @DocumentId
            @Id
            Long id;
            @Field(indexNullAs="foo")
            boolean myField;
        }
    }

    protected static abstract class AbstractIndexNullAsFailureTest
    implements TestConfiguration {
        @Rule
        public ExpectedException thrown = ExpectedException.none();
        private DefaultTestResourceManager testResourceManager;

        protected AbstractIndexNullAsFailureTest() {
        }

        protected void init() {
            this.getTestResourceManager().openSessionFactory();
        }

        private synchronized DefaultTestResourceManager getTestResourceManager() {
            if (this.testResourceManager == null) {
                this.testResourceManager = new DefaultTestResourceManager((TestConfiguration)this, this.getClass());
            }
            return this.testResourceManager;
        }

        public void configure(Map<String, Object> settings) {
            settings.put("elasticsearch.index_schema_management_strategy", IndexSchemaManagementStrategy.RECREATE);
        }

        public Set<String> multiTenantIds() {
            return Collections.emptySet();
        }
    }
}

