/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import java.net.ConnectException;
import org.fest.assertions.Assertions;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.search.elasticsearch.test.MasterThesis;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.service.ServiceRegistry;
import org.junit.Assert;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-2274")
public class HostCanBeConfiguredIT {
    @Test
    public void shouldApplyConfiguredElasticsearchHost() {
        StandardServiceRegistryBuilder srb = new StandardServiceRegistryBuilder().applySetting("hibernate.search.default.elasticsearch.host", (Object)"http://localhost:9201");
        Metadata metadata = new MetadataSources((ServiceRegistry)srb.build()).addAnnotatedClass(MasterThesis.class).buildMetadata();
        try {
            metadata.buildSessionFactory();
            Assert.fail((String)"Expecting exception due to unavailable ES host");
        }
        catch (SearchException e) {
            Assertions.assertThat((String)e.getMessage()).startsWith("HSEARCH400007");
            Throwable rootCause = this.getRootCause(e);
            Assertions.assertThat((Throwable)rootCause).isInstanceOf(ConnectException.class);
            Assertions.assertThat((Throwable)rootCause).hasMessage("Connection refused");
        }
    }

    private Throwable getRootCause(Throwable throwable) {
        Throwable cause;
        while ((cause = throwable.getCause()) != null) {
            throwable = cause;
        }
        return throwable;
    }
}

