/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.testutil;

import org.hibernate.search.exception.AssertionFailure;
import org.json.JSONException;
import org.skyscreamer.jsonassert.JSONCompare;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.skyscreamer.jsonassert.JSONCompareResult;

public class JsonHelper {
    private JsonHelper() {
    }

    public static void assertJsonEquals(String expectedJson, String actualJson) {
        JsonHelper.assertJsonEquals(expectedJson, actualJson, JSONCompareMode.NON_EXTENSIBLE);
    }

    public static void assertJsonEqualsIgnoringUnknownFields(String expectedJson, String actualJson) {
        JsonHelper.assertJsonEquals(expectedJson, actualJson, JSONCompareMode.LENIENT);
    }

    private static void assertJsonEquals(String expectedJson, String actualJson, JSONCompareMode mode) {
        try {
            JSONCompareResult result = JSONCompare.compareJSON((String)expectedJson, (String)actualJson, (JSONCompareMode)mode);
            if (result.failed()) {
                throw new AssertionFailure(result.getMessage() + "; Actual: " + actualJson);
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }
}

