/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.util.impl;

import java.util.Collection;
import java.util.Set;
import org.hibernate.search.elasticsearch.spi.ElasticsearchIndexManagerType;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.indexes.spi.IndexManagerType;

public final class ElasticsearchEntityHelper {
    private ElasticsearchEntityHelper() {
    }

    public static boolean isMappedToElasticsearch(ExtendedSearchIntegrator integrator, Class<?> entityType) {
        Set entityTypesWithSubTypes = integrator.getIndexedTypesPolymorphic(new Class[]{entityType});
        return ElasticsearchEntityHelper.hasElasticsearchIndexManager(integrator, entityTypesWithSubTypes);
    }

    public static boolean isAnyMappedToElasticsearch(ExtendedSearchIntegrator integrator, Collection<Class<?>> entityTypes) {
        Set entityTypesWithSubTypes = integrator.getIndexedTypesPolymorphic(entityTypes.toArray(new Class[entityTypes.size()]));
        return ElasticsearchEntityHelper.hasElasticsearchIndexManager(integrator, entityTypesWithSubTypes);
    }

    private static boolean hasElasticsearchIndexManager(ExtendedSearchIntegrator integrator, Collection<Class<?>> entityTypes) {
        for (Class<?> entityType : entityTypes) {
            IndexManagerType indexManagerType;
            EntityIndexBinding binding = integrator.getIndexBinding(entityType);
            if (binding == null || !ElasticsearchIndexManagerType.INSTANCE.equals(indexManagerType = binding.getIndexManagerType())) continue;
            return true;
        }
        return false;
    }
}

