/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.searchbox.action.Action;
import io.searchbox.core.DocumentResult;
import io.searchbox.core.Index;
import io.searchbox.core.Search;
import io.searchbox.core.SearchResult;
import org.eclipse.jetty.http.HttpHeader;
import org.fest.assertions.Assertions;
import org.fest.assertions.BooleanAssert;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.elasticsearch.client.impl.JestClient;
import org.hibernate.search.elasticsearch.impl.JsonBuilder;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.test.util.impl.ExpectedLog4jLog;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.setup.BuildContextForTest;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class JestClientTest {
    private static final String CLIENT_PROPERTY_PREFIX = "hibernate.search.default.";
    private static final int PORT_1 = 9201;
    private static final String URI_1 = "http://localhost:9201";
    private static final int PORT_2 = 9202;
    private static final String URI_2 = "http://localhost:9202";
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public ExpectedLog4jLog logged = ExpectedLog4jLog.create();
    @Rule
    public WireMockRule wireMockRule1 = new WireMockRule(9201);
    @Rule
    public WireMockRule wireMockRule2 = new WireMockRule(9202);
    private JestClient jestClient = new JestClient();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @TestForIssue(jiraKey="HSEARCH-2274")
    public void simple() {
        SearchConfigurationForTest configuration = new SearchConfigurationForTest().addProperty("hibernate.search.default.elasticsearch.host", URI_1);
        String payload = "{ \"foo\": \"bar\" }";
        this.wireMockRule1.stubFor(WireMock.post((UrlPattern)WireMock.urlPathEqualTo((String)"/myIndex/myType")).withRequestBody(WireMock.equalToJson((String)payload)).willReturn(JestClientTest.elasticsearchResponse().withStatus(200)));
        try {
            this.jestClient.start(configuration.getProperties(), (BuildContext)new BuildContextForTest((SearchConfiguration)configuration));
            Index request = ((Index.Builder)((Index.Builder)new Index.Builder((Object)payload).index("myIndex")).type("myType")).build();
            DocumentResult result = (DocumentResult)this.jestClient.executeRequest((Action)request);
            ((BooleanAssert)Assertions.assertThat((boolean)result.isSucceeded()).as("isSucceeded")).isTrue();
            this.wireMockRule1.verify(WireMock.postRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/myIndex/myType")));
        }
        finally {
            this.jestClient.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void error() {
        SearchConfigurationForTest configuration = new SearchConfigurationForTest().addProperty("hibernate.search.default.elasticsearch.host", URI_1);
        String payload = "{ \"foo\": \"bar\" }";
        String errorMessage = "ErrorMessageExplainingTheError";
        this.thrown.expectMessage("HSEARCH400007");
        this.thrown.expectMessage("500");
        this.thrown.expectMessage(errorMessage);
        this.wireMockRule1.stubFor(WireMock.post((UrlPattern)WireMock.urlPathEqualTo((String)"/myIndex/myType")).withRequestBody(WireMock.equalToJson((String)payload)).willReturn(JestClientTest.elasticsearchResponse().withStatus(500).withBody("{ \"error\": \"" + errorMessage + "\" }")));
        try {
            this.jestClient.start(configuration.getProperties(), (BuildContext)new BuildContextForTest((SearchConfiguration)configuration));
            Index request = ((Index.Builder)((Index.Builder)new Index.Builder((Object)payload).index("myIndex")).type("myType")).build();
            this.jestClient.executeRequest((Action)request);
        }
        finally {
            this.jestClient.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @TestForIssue(jiraKey="HSEARCH-2235")
    public void multipleHosts() {
        SearchConfigurationForTest configuration = new SearchConfigurationForTest().addProperty("hibernate.search.default.elasticsearch.host", "http://localhost:9201 http://localhost:9202");
        String payload = "{ \"foo\": \"bar\" }";
        this.wireMockRule1.stubFor(WireMock.post((UrlPattern)WireMock.urlPathEqualTo((String)"/myIndex/myType")).withRequestBody(WireMock.equalToJson((String)payload)).willReturn(JestClientTest.elasticsearchResponse().withStatus(200)));
        this.wireMockRule2.stubFor(WireMock.post((UrlPattern)WireMock.urlPathEqualTo((String)"/myIndex/myType")).withRequestBody(WireMock.equalToJson((String)payload)).willReturn(JestClientTest.elasticsearchResponse().withStatus(200)));
        try {
            this.jestClient.start(configuration.getProperties(), (BuildContext)new BuildContextForTest((SearchConfiguration)configuration));
            Index request = ((Index.Builder)((Index.Builder)new Index.Builder((Object)payload).index("myIndex")).type("myType")).build();
            DocumentResult result = (DocumentResult)this.jestClient.executeRequest((Action)request);
            ((BooleanAssert)Assertions.assertThat((boolean)result.isSucceeded()).as("isSucceeded")).isTrue();
            result = (DocumentResult)this.jestClient.executeRequest((Action)request);
            ((BooleanAssert)Assertions.assertThat((boolean)result.isSucceeded()).as("isSucceeded")).isTrue();
            this.wireMockRule1.verify(WireMock.postRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/myIndex/myType")));
            this.wireMockRule2.verify(WireMock.postRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/myIndex/myType")));
        }
        finally {
            this.jestClient.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @TestForIssue(jiraKey="HSEARCH-2449")
    public void discovery() throws Exception {
        SearchConfigurationForTest configuration = new SearchConfigurationForTest().addProperty("hibernate.search.default.elasticsearch.host", URI_1).addProperty("hibernate.search.default.elasticsearch.discovery.enabled", "true").addProperty("hibernate.search.default.elasticsearch.discovery.refresh_interval", "1");
        String nodesInfoResult = this.dummyNodeInfoResponse(9201, 9202);
        this.wireMockRule1.stubFor(WireMock.get((UrlPattern)WireMock.urlMatching((String)"/_nodes.*")).willReturn(JestClientTest.elasticsearchResponse().withStatus(200).withBody(nodesInfoResult)));
        this.wireMockRule2.stubFor(WireMock.get((UrlPattern)WireMock.urlMatching((String)"/_nodes.*")).willReturn(JestClientTest.elasticsearchResponse().withStatus(200).withBody(nodesInfoResult)));
        String payload = "{ \"foo\": \"bar\" }";
        this.wireMockRule1.stubFor(WireMock.post((UrlPattern)WireMock.urlPathEqualTo((String)"/myIndex/myType")).withRequestBody(WireMock.equalToJson((String)payload)).willReturn(JestClientTest.elasticsearchResponse().withStatus(200)));
        this.wireMockRule2.stubFor(WireMock.post((UrlPattern)WireMock.urlPathEqualTo((String)"/myIndex/myType")).withRequestBody(WireMock.equalToJson((String)payload)).willReturn(JestClientTest.elasticsearchResponse().withStatus(200)));
        try {
            this.jestClient.start(configuration.getProperties(), (BuildContext)new BuildContextForTest((SearchConfiguration)configuration));
            Index request = ((Index.Builder)((Index.Builder)new Index.Builder((Object)payload).index("myIndex")).type("myType")).build();
            DocumentResult result = (DocumentResult)this.jestClient.executeRequest((Action)request);
            ((BooleanAssert)Assertions.assertThat((boolean)result.isSucceeded()).as("isSucceeded")).isTrue();
            Thread.sleep(2000L);
            result = (DocumentResult)this.jestClient.executeRequest((Action)request);
            ((BooleanAssert)Assertions.assertThat((boolean)result.isSucceeded()).as("isSucceeded")).isTrue();
            result = (DocumentResult)this.jestClient.executeRequest((Action)request);
            ((BooleanAssert)Assertions.assertThat((boolean)result.isSucceeded()).as("isSucceeded")).isTrue();
            this.wireMockRule1.verify(WireMock.postRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/myIndex/myType")));
            this.wireMockRule2.verify(WireMock.postRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/myIndex/myType")));
        }
        finally {
            this.jestClient.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @TestForIssue(jiraKey="HSEARCH-2453")
    public void authentication() {
        String username = "ironman";
        String password = "j@rV1s";
        SearchConfigurationForTest configuration = new SearchConfigurationForTest().addProperty("hibernate.search.default.elasticsearch.host", URI_1).addProperty("hibernate.search.default.elasticsearch.username", username).addProperty("hibernate.search.default.elasticsearch.password", password);
        String payload = "{ \"foo\": \"bar\" }";
        this.wireMockRule1.stubFor(WireMock.post((UrlPattern)WireMock.urlPathEqualTo((String)"/myIndex/myType/_search")).withRequestBody(WireMock.equalToJson((String)payload)).willReturn(JestClientTest.elasticsearchResponse().withStatus(401).withHeader(HttpHeader.WWW_AUTHENTICATE.asString(), new String[]{"Basic"})));
        this.wireMockRule1.stubFor(WireMock.post((UrlPattern)WireMock.urlPathEqualTo((String)"/myIndex/myType/_search")).withBasicAuth(username, password).withRequestBody(WireMock.equalToJson((String)payload)).willReturn(JestClientTest.elasticsearchResponse().withStatus(200)));
        try {
            this.jestClient.start(configuration.getProperties(), (BuildContext)new BuildContextForTest((SearchConfiguration)configuration));
            Search request = ((Search.Builder)((Search.Builder)new Search.Builder(payload).addIndex("myIndex")).addType("myType")).build();
            SearchResult result = (SearchResult)this.jestClient.executeRequest((Action)request);
            ((BooleanAssert)Assertions.assertThat((boolean)result.isSucceeded()).as("isSucceeded")).isTrue();
            this.wireMockRule1.verify(WireMock.postRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/myIndex/myType/_search")));
        }
        finally {
            this.jestClient.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @TestForIssue(jiraKey="HSEARCH-2453")
    public void authentication_error() {
        SearchConfigurationForTest configuration = new SearchConfigurationForTest().addProperty("hibernate.search.default.elasticsearch.host", URI_1);
        String payload = "{ \"foo\": \"bar\" }";
        String statusMessage = "StatusMessageUnauthorized";
        this.thrown.expectMessage("HSEARCH400007");
        this.thrown.expectMessage("401");
        this.thrown.expectMessage(statusMessage);
        this.wireMockRule1.stubFor(WireMock.post((UrlPattern)WireMock.urlPathEqualTo((String)"/myIndex/myType/_search")).withRequestBody(WireMock.equalToJson((String)payload)).willReturn(JestClientTest.elasticsearchResponse().withStatus(401).withStatusMessage(statusMessage)));
        try {
            this.jestClient.start(configuration.getProperties(), (BuildContext)new BuildContextForTest((SearchConfiguration)configuration));
            Search request = ((Search.Builder)((Search.Builder)new Search.Builder(payload).addIndex("myIndex")).addType("myType")).build();
            this.jestClient.executeRequest((Action)request);
        }
        finally {
            this.jestClient.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @TestForIssue(jiraKey="HSEARCH-2453")
    public void authentication_http_password() {
        String username = "ironman";
        String password = "j@rV1s";
        String httpUri = "http://foo.com/";
        SearchConfigurationForTest configuration = new SearchConfigurationForTest().addProperty("hibernate.search.default.elasticsearch.host", httpUri).addProperty("hibernate.search.default.elasticsearch.username", username).addProperty("hibernate.search.default.elasticsearch.password", password);
        this.logged.expectMessage("HSEARCH400073", new String[]{httpUri});
        try {
            this.jestClient.start(configuration.getProperties(), (BuildContext)new BuildContextForTest((SearchConfiguration)configuration));
        }
        finally {
            this.jestClient.stop();
        }
    }

    private static ResponseDefinitionBuilder elasticsearchResponse() {
        return ResponseDefinitionBuilder.okForEmptyJson();
    }

    private String dummyNodeInfoResponse(int ... ports) {
        JsonBuilder.Object nodesBuilder = JsonBuilder.object();
        int index = 1;
        for (int port : ports) {
            nodesBuilder.add("hJLXmY_NTrCytiIMbX4_" + index + "g", (JsonElement)this.dummyNodeInfo(port));
            ++index;
        }
        return JsonBuilder.object().addProperty("cluster_name", "foo-cluster.local").add("nodes", (JsonElement)nodesBuilder.build()).build().toString();
    }

    private JsonObject dummyNodeInfo(int port) {
        return JsonBuilder.object().addProperty("name", "nodeForPort" + port).addProperty("transport_address", "inet[/localhost:" + (port + 100) + "]").addProperty("hostname", "localhost").addProperty("version", "2.4.4").addProperty("http_address", "inet[/localhost:" + port + "]").add("plugins", (JsonElement)JsonBuilder.array().build()).build();
    }
}

