/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.client.impl;

import io.searchbox.core.BulkResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.elasticsearch.client.impl.BackendRequest;
import org.hibernate.search.elasticsearch.client.impl.BulkRequestFailedException;
import org.hibernate.search.elasticsearch.client.impl.ExecutableRequest;
import org.hibernate.search.elasticsearch.client.impl.JestClient;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.exception.impl.ErrorContextBuilder;

public class BulkRequest
implements ExecutableRequest {
    private final JestClient jestClient;
    private final ErrorHandler errorHandler;
    private final List<BackendRequest<?>> requests;
    private final boolean refresh;
    private final Set<String> indexNames;
    private final Set<String> indexesNeedingRefresh;

    public BulkRequest(JestClient jestClient, ErrorHandler errorHandler, List<BackendRequest<?>> requests, Set<String> indexNames, Set<String> indexesNeedingRefresh, boolean refresh) {
        this.jestClient = jestClient;
        this.errorHandler = errorHandler;
        this.requests = requests;
        this.indexNames = indexNames;
        this.indexesNeedingRefresh = indexesNeedingRefresh;
        this.refresh = refresh;
    }

    @Override
    public void execute() {
        Map<BackendRequest<?>, BulkResult.BulkResultItem> results = null;
        try {
            results = this.jestClient.executeBulkRequest(this.requests, this.refresh);
            RuntimeException e = this.reportResults(results, null);
            if (e != null) {
                throw e;
            }
        }
        catch (BulkRequestFailedException brfe) {
            this.reportResults(brfe.getSuccessfulItems(), (RuntimeException)((Object)brfe));
            ErrorContextBuilder builder = new ErrorContextBuilder();
            ArrayList allWork = new ArrayList();
            builder.allWorkToBeDone(allWork);
            for (BackendRequest<?> failedAction : brfe.getErroneousItems()) {
                builder.addWorkThatFailed(failedAction.getLuceneWork());
            }
            builder.errorThatOccurred((Throwable)((Object)brfe));
            this.errorHandler.handle(builder.createErrorContext());
        }
        catch (Exception e) {
            this.errorHandler.handleException("Bulk request failed", (Throwable)e);
        }
    }

    private RuntimeException reportResults(Map<BackendRequest<?>, BulkResult.BulkResultItem> successfulItems, RuntimeException preexistingMainException) {
        HashMap<IndexingMonitor, BufferingIndexMonitor> buffers = new HashMap<IndexingMonitor, BufferingIndexMonitor>();
        RuntimeException mainException = preexistingMainException;
        for (Map.Entry<BackendRequest<?>, BulkResult.BulkResultItem> entry : successfulItems.entrySet()) {
            try {
                this.reportResult(buffers, entry);
            }
            catch (RuntimeException e) {
                mainException = this.returnOrSuppressException(mainException, e);
            }
        }
        for (BufferingIndexMonitor buffer : buffers.values()) {
            try {
                buffer.flush();
            }
            catch (RuntimeException e) {
                mainException = this.returnOrSuppressException(mainException, e);
            }
        }
        return mainException;
    }

    private RuntimeException returnOrSuppressException(RuntimeException existingException, RuntimeException newException) {
        if (existingException == null) {
            return newException;
        }
        existingException.addSuppressed(newException);
        return existingException;
    }

    private void reportResult(Map<IndexingMonitor, BufferingIndexMonitor> buffers, Map.Entry<BackendRequest<?>, BulkResult.BulkResultItem> entry) {
        BackendRequest<?> request = entry.getKey();
        BulkResult.BulkResultItem result = entry.getValue();
        IndexingMonitor originalMonitor = request.getIndexingMonitor();
        if (originalMonitor == null) {
            return;
        }
        BufferingIndexMonitor bufferingMonitor = buffers.get(originalMonitor);
        if (bufferingMonitor == null) {
            bufferingMonitor = new BufferingIndexMonitor(originalMonitor);
            buffers.put(originalMonitor, bufferingMonitor);
        }
        request.getSuccessReporter().report(result, (IndexingMonitor)bufferingMonitor);
    }

    @Override
    public Set<String> getTouchedIndexes() {
        return this.indexNames;
    }

    @Override
    public Set<String> getIndexesNeedingRefresh() {
        if (this.refresh) {
            return Collections.emptySet();
        }
        return this.indexesNeedingRefresh;
    }

    @Override
    public int getSize() {
        return this.requests.size();
    }

    public String toString() {
        return "BulkRequest [size=" + this.requests.size() + ", refresh=" + this.refresh + ", indexNames=" + this.indexNames + ", indexesNeedingRefresh=" + this.indexesNeedingRefresh + "]";
    }

    private static final class BufferingIndexMonitor
    implements IndexingMonitor {
        private final IndexingMonitor delegate;
        private long documentsAdded = 0L;

        public BufferingIndexMonitor(IndexingMonitor delegate) {
            this.delegate = delegate;
        }

        public void documentsAdded(long increment) {
            this.documentsAdded += increment;
        }

        private void flush() {
            this.delegate.documentsAdded(this.documentsAdded);
            this.documentsAdded = 0L;
        }
    }
}

