/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.util.impl;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import org.apache.lucene.document.DateTools;

public final class ElasticsearchDateHelper {
    private static final TimeZone ENCODING_TIME_ZONE = TimeZone.getTimeZone("UTC");

    private ElasticsearchDateHelper() {
    }

    public static Date stringToDate(String value) {
        Calendar c = DatatypeConverter.parseDateTime((String)value);
        return c.getTime();
    }

    public static String dateToString(Date date) {
        Calendar c = Calendar.getInstance(ENCODING_TIME_ZONE, Locale.ENGLISH);
        c.setTime(date);
        return DatatypeConverter.printDateTime((Calendar)c);
    }

    public static String calendarToString(Calendar calendar) {
        return DatatypeConverter.printDateTime((Calendar)calendar);
    }

    public static Calendar stringToCalendar(String value) {
        return DatatypeConverter.parseDateTime((String)value);
    }

    public static Calendar round(Calendar calendar, DateTools.Resolution resolution) {
        Calendar calInstance = (Calendar)calendar.clone();
        calInstance.setTime(DateTools.round((Date)calInstance.getTime(), (DateTools.Resolution)resolution));
        return calInstance;
    }
}

