/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.MetadataProvidingFieldBridge;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.spi.FieldMetadataBuilder;
import org.hibernate.search.bridge.spi.FieldType;
import org.hibernate.search.elasticsearch.test.GolfPlayer;

public class AgeBridge
implements TwoWayFieldBridge,
MetadataProvidingFieldBridge {
    public void configureFieldMetadata(String name, FieldMetadataBuilder builder) {
        builder.field(name, FieldType.INTEGER);
    }

    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        Integer age = this.getAge(value);
        if (age != null) {
            luceneOptions.addNumericFieldToDocument(name, (Object)age, document);
        }
    }

    public Object get(String name, Document document) {
        IndexableField field = document.getField(name);
        return field == null ? (Number)null : (Number)field.numericValue();
    }

    private Integer getAge(Object object) {
        GolfPlayer player = (GolfPlayer)object;
        if (player.getDateOfBirth() != null) {
            return 34;
        }
        return null;
    }

    public String objectToString(Object object) {
        Integer age = this.getAge(object);
        return age == null ? null : age.toString();
    }
}

