/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test.bridge;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.Query;
import org.fest.assertions.Assertions;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.elasticsearch.schema.impl.model.DynamicType;
import org.hibernate.search.elasticsearch.test.bridge.ElasticsearchDynamicIndexedValueHolder;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.exception.ErrorContext;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.setup.TransactionContextForTest;
import org.junit.Rule;
import org.junit.Test;

public class DynamicMappingIT {
    private static final String DYNAMIC_MAPPING = "hibernate.search.elasticsearchDynamicIndex.elasticsearch.dynamic_mapping";
    @Rule
    public SearchFactoryHolder sfHolder = new SearchFactoryHolder(new Class[]{ElasticsearchDynamicIndexedValueHolder.class}).withProperty("hibernate.search.error_handler", (Object)TestExceptionHandler.class.getName()).withProperty("hibernate.search.elasticsearchDynamicIndex.elasticsearch.dynamic_mapping", (Object)DynamicType.STRICT.name());

    @Test
    public void testIndexingWithDynamicField() {
        ElasticsearchDynamicIndexedValueHolder holder = new ElasticsearchDynamicIndexedValueHolder("1").dynamicProperty("age", "227").dynamicProperty("name", "Thorin").dynamicProperty("surname", "Oakenshield").dynamicProperty("race", "dwarf");
        this.index(holder);
        List<EntityInfo> fieldValue = this.searchField("dynamicField.name");
        Assertions.assertThat(fieldValue).hasSize(1);
        Assertions.assertThat((Object)fieldValue.get(0).getProjection()[0]).isEqualTo((Object)"Thorin");
    }

    @Test
    public void testIndexingWithStrictField() {
        ElasticsearchDynamicIndexedValueHolder holder = new ElasticsearchDynamicIndexedValueHolder("2").strictProperty("age", "64").strictProperty("name", "Gimli").strictProperty("race", "dwarf");
        this.index(holder);
        TestExceptionHandler errorHandler = this.getErrorHandler();
        Assertions.assertThat(errorHandler.getHandleInvocations()).hasSize(1);
        ErrorContext errorContext = errorHandler.getHandleInvocations().get(0);
        Throwable throwable = errorContext.getThrowable();
        Assertions.assertThat((Throwable)throwable).isInstanceOf(SearchException.class);
        Assertions.assertThat((String)throwable.getMessage()).startsWith("HSEARCH400007");
        Assertions.assertThat((String)throwable.getMessage()).contains("strict_dynamic_mapping_exception");
        Assertions.assertThat((String)throwable.getMessage()).contains("strictField");
    }

    private TestExceptionHandler getErrorHandler() {
        ExtendedSearchIntegrator searchFactory = this.sfHolder.getSearchFactory();
        ErrorHandler errorHandler = searchFactory.getErrorHandler();
        Assertions.assertThat((Object)errorHandler).isInstanceOf(TestExceptionHandler.class);
        return (TestExceptionHandler)errorHandler;
    }

    private void index(ElasticsearchDynamicIndexedValueHolder holder) {
        ExtendedSearchIntegrator searchFactory = this.sfHolder.getSearchFactory();
        Work work = new Work((Object)holder, (Serializable)((Object)holder.id), WorkType.ADD, false);
        TransactionContextForTest tc = new TransactionContextForTest();
        searchFactory.getWorker().performWork(work, (TransactionContext)tc);
        tc.end();
    }

    private List<EntityInfo> searchField(String field) {
        ExtendedSearchIntegrator searchFactory = this.sfHolder.getSearchFactory();
        QueryBuilder guestQueryBuilder = searchFactory.buildQueryBuilder().forEntity(ElasticsearchDynamicIndexedValueHolder.class).get();
        Query queryAllGuests = guestQueryBuilder.all().createQuery();
        return searchFactory.createHSQuery(queryAllGuests, new Class[]{ElasticsearchDynamicIndexedValueHolder.class}).projection(new String[]{field}).queryEntityInfos();
    }

    public static class TestExceptionHandler
    implements ErrorHandler {
        private List<ErrorContext> handleInvocations = new ArrayList<ErrorContext>();

        public void handle(ErrorContext context) {
            this.handleInvocations.add(context);
        }

        public void handleException(String errorMsg, Throwable exception) {
        }

        public List<ErrorContext> getHandleInvocations() {
            return this.handleInvocations;
        }

        public void reset() {
            this.handleInvocations.clear();
        }
    }
}

