/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.bridge.builtin.time.impl;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.util.Locale;
import org.hibernate.search.elasticsearch.bridge.builtin.time.impl.ElasticsearchOffsetDateTimeBridge;
import org.hibernate.search.elasticsearch.bridge.builtin.time.impl.ElasticsearchTemporalAccessorStringBridge;
import org.hibernate.search.util.impl.TimeHelper;

public class ElasticsearchZonedDateTimeBridge
extends ElasticsearchTemporalAccessorStringBridge<ZonedDateTime> {
    private static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().append(ElasticsearchOffsetDateTimeBridge.FORMATTER).appendLiteral('[').parseCaseSensitive().appendZoneRegionId().appendLiteral(']').toFormatter(Locale.ROOT).withResolverStyle(ResolverStyle.STRICT);
    public static final ElasticsearchZonedDateTimeBridge INSTANCE = new ElasticsearchZonedDateTimeBridge();

    private ElasticsearchZonedDateTimeBridge() {
        super(FORMATTER, ZonedDateTime.class);
    }

    @Override
    ZonedDateTime parse(DateTimeFormatter formatter, String stringValue) throws DateTimeParseException {
        return TimeHelper.parseZoneDateTime((String)stringValue, (DateTimeFormatter)formatter);
    }
}

