/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.impl;

import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import java.util.regex.Pattern;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.builtin.NumericFieldBridge;
import org.hibernate.search.bridge.builtin.impl.NullEncodingTwoWayFieldBridge;
import org.hibernate.search.bridge.spi.FieldType;
import org.hibernate.search.engine.metadata.impl.BridgeDefinedField;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;
import org.hibernate.search.engine.metadata.impl.EmbeddedTypeMetadata;
import org.hibernate.search.engine.metadata.impl.PropertyMetadata;
import org.hibernate.search.engine.metadata.impl.SortableFieldMetadata;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.metadata.NumericFieldSettingsDescriptor;

class FieldHelper {
    private static final Pattern DOT = Pattern.compile("\\.");

    private FieldHelper() {
    }

    private static NumericFieldSettingsDescriptor.NumericEncodingType getNumericEncodingType(EntityIndexBinding indexBinding, DocumentFieldMetadata field) {
        BridgeDefinedField bridgeDefinedField;
        PropertyMetadata hostingProperty;
        NumericFieldSettingsDescriptor.NumericEncodingType numericEncodingType = field.getNumericEncodingType();
        if (numericEncodingType == NumericFieldSettingsDescriptor.NumericEncodingType.UNKNOWN && (hostingProperty = FieldHelper.getPropertyMetadata(indexBinding, field.getName())) != null && (bridgeDefinedField = (BridgeDefinedField)hostingProperty.getBridgeDefinedFields().get(field.getName())) != null) {
            numericEncodingType = FieldHelper.getNumericEncodingType(bridgeDefinedField.getType());
        }
        return numericEncodingType;
    }

    private static NumericFieldSettingsDescriptor.NumericEncodingType getNumericEncodingType(FieldType fieldType) {
        switch (fieldType) {
            case FLOAT: {
                return NumericFieldSettingsDescriptor.NumericEncodingType.FLOAT;
            }
            case DOUBLE: {
                return NumericFieldSettingsDescriptor.NumericEncodingType.DOUBLE;
            }
            case INTEGER: {
                return NumericFieldSettingsDescriptor.NumericEncodingType.INTEGER;
            }
            case LONG: {
                return NumericFieldSettingsDescriptor.NumericEncodingType.LONG;
            }
        }
        return NumericFieldSettingsDescriptor.NumericEncodingType.UNKNOWN;
    }

    private static ExtendedFieldType toExtendedFieldType(NumericFieldSettingsDescriptor.NumericEncodingType numericEncodingType) {
        switch (numericEncodingType) {
            case INTEGER: {
                return ExtendedFieldType.INTEGER;
            }
            case LONG: {
                return ExtendedFieldType.LONG;
            }
            case FLOAT: {
                return ExtendedFieldType.FLOAT;
            }
            case DOUBLE: {
                return ExtendedFieldType.DOUBLE;
            }
        }
        return ExtendedFieldType.UNKNOWN_NUMERIC;
    }

    static ExtendedFieldType getType(EntityIndexBinding indexBinding, DocumentFieldMetadata fieldMetadata) {
        String fieldName = fieldMetadata.getFieldName();
        Class<?> propertyClass = FieldHelper.getPropertyClass(indexBinding, fieldName);
        if (propertyClass == null) {
            return ExtendedFieldType.UNKNOWN;
        }
        if (Boolean.TYPE.equals(propertyClass) || Boolean.class.isAssignableFrom(propertyClass)) {
            return ExtendedFieldType.BOOLEAN;
        }
        if (FieldHelper.isNumeric(fieldMetadata)) {
            return FieldHelper.toExtendedFieldType(FieldHelper.getNumericEncodingType(indexBinding, fieldMetadata));
        }
        if (Date.class.isAssignableFrom(propertyClass)) {
            return ExtendedFieldType.DATE;
        }
        if (Calendar.class.isAssignableFrom(propertyClass)) {
            return ExtendedFieldType.CALENDAR;
        }
        if ("java.time.Instant".equals(propertyClass.getName())) {
            return ExtendedFieldType.INSTANT;
        }
        if ("java.time.LocalDate".equals(propertyClass.getName())) {
            return ExtendedFieldType.LOCAL_DATE;
        }
        if ("java.time.LocalTime".equals(propertyClass.getName())) {
            return ExtendedFieldType.LOCAL_TIME;
        }
        if ("java.time.LocalDateTime".equals(propertyClass.getName())) {
            return ExtendedFieldType.LOCAL_DATE_TIME;
        }
        if ("java.time.OffsetDateTime".equals(propertyClass.getName())) {
            return ExtendedFieldType.OFFSET_DATE_TIME;
        }
        if ("java.time.OffsetTime".equals(propertyClass.getName())) {
            return ExtendedFieldType.OFFSET_TIME;
        }
        if ("java.time.ZonedDateTime".equals(propertyClass.getName())) {
            return ExtendedFieldType.ZONED_DATE_TIME;
        }
        if ("java.time.Year".equals(propertyClass.getName())) {
            return ExtendedFieldType.YEAR;
        }
        if ("java.time.YearMonth".equals(propertyClass.getName())) {
            return ExtendedFieldType.YEAR_MONTH;
        }
        if ("java.time.MonthDay".equals(propertyClass.getName())) {
            return ExtendedFieldType.MONTH_DAY;
        }
        return ExtendedFieldType.UNKNOWN;
    }

    static ExtendedFieldType getType(BridgeDefinedField field) {
        FieldType type = field.getType();
        if (type == null) {
            return null;
        }
        switch (type) {
            case BOOLEAN: {
                return ExtendedFieldType.BOOLEAN;
            }
            case DATE: {
                return ExtendedFieldType.DATE;
            }
            case DOUBLE: {
                return ExtendedFieldType.DOUBLE;
            }
            case FLOAT: {
                return ExtendedFieldType.FLOAT;
            }
            case INTEGER: {
                return ExtendedFieldType.INTEGER;
            }
            case LONG: {
                return ExtendedFieldType.LONG;
            }
            case STRING: {
                return ExtendedFieldType.STRING;
            }
        }
        return ExtendedFieldType.UNKNOWN;
    }

    static boolean isNumeric(DocumentFieldMetadata field) {
        if (field.isNumeric()) {
            return true;
        }
        FieldBridge fieldBridge = field.getFieldBridge();
        if (fieldBridge instanceof NullEncodingTwoWayFieldBridge) {
            return ((NullEncodingTwoWayFieldBridge)fieldBridge).unwrap() instanceof NumericFieldBridge;
        }
        return false;
    }

    static String[] getFieldNameParts(String fieldName) {
        String[] stringArray;
        boolean isEmbeddedField = FieldHelper.isEmbeddedField(fieldName);
        if (isEmbeddedField) {
            stringArray = DOT.split(fieldName);
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = fieldName;
        }
        return stringArray;
    }

    private static Class<?> getPropertyClass(EntityIndexBinding indexBinding, String fieldName) {
        PropertyMetadata propertyMetadata = FieldHelper.getPropertyMetadata(indexBinding, fieldName);
        return propertyMetadata != null ? propertyMetadata.getPropertyClass() : null;
    }

    private static PropertyMetadata getPropertyMetadata(EntityIndexBinding indexBinding, String fieldName) {
        String[] stringArray;
        boolean isEmbeddedField = FieldHelper.isEmbeddedField(fieldName);
        if (isEmbeddedField) {
            stringArray = DOT.split(fieldName);
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = fieldName;
        }
        String[] fieldNameParts = stringArray;
        TypeMetadata typeMetadata = isEmbeddedField ? FieldHelper.getLeafTypeMetadata(indexBinding, fieldNameParts) : indexBinding.getDocumentBuilder().getMetadata();
        PropertyMetadata property = FieldHelper.getPropertyMetadata(typeMetadata, fieldName, fieldNameParts);
        if (property != null) {
            return property;
        }
        return null;
    }

    static DocumentFieldMetadata getFieldMetadata(EntityIndexBinding indexBinding, String fieldName) {
        if (indexBinding.getDocumentBuilder().getIdentifierName().equals(fieldName)) {
            return indexBinding.getDocumentBuilder().getTypeMetadata().getIdPropertyMetadata().getFieldMetadata(fieldName);
        }
        PropertyMetadata property = FieldHelper.getPropertyMetadata(indexBinding, fieldName);
        if (property != null) {
            return property.getFieldMetadata(fieldName);
        }
        Set classBridgeMetadata = indexBinding.getDocumentBuilder().getMetadata().getClassBridgeMetadata();
        for (DocumentFieldMetadata documentFieldMetadata : classBridgeMetadata) {
            if (!documentFieldMetadata.getFieldName().equals(fieldName)) continue;
            return documentFieldMetadata;
        }
        return null;
    }

    private static TypeMetadata getLeafTypeMetadata(EntityIndexBinding indexBinding, String[] fieldNameParts) {
        TypeMetadata parentMetadata = indexBinding.getDocumentBuilder().getMetadata();
        block0: for (int i = 0; i < fieldNameParts.length - 1; ++i) {
            for (EmbeddedTypeMetadata embeddedTypeMetadata : parentMetadata.getEmbeddedTypeMetadata()) {
                if (!embeddedTypeMetadata.getEmbeddedFieldName().equals(fieldNameParts[i])) continue;
                parentMetadata = embeddedTypeMetadata;
                continue block0;
            }
        }
        return parentMetadata;
    }

    private static PropertyMetadata getPropertyMetadata(TypeMetadata type, String fieldName, String[] fieldNameParts) {
        String lastParticle = fieldNameParts[fieldNameParts.length - 1];
        for (PropertyMetadata property : type.getAllPropertyMetadata()) {
            for (DocumentFieldMetadata field : property.getFieldMetadata()) {
                if (!field.getName().equals(fieldName)) continue;
                return property;
            }
        }
        for (EmbeddedTypeMetadata embeddedType : type.getEmbeddedTypeMetadata()) {
            if (!lastParticle.startsWith(embeddedType.getEmbeddedFieldName())) continue;
            for (PropertyMetadata property : embeddedType.getAllPropertyMetadata()) {
                for (DocumentFieldMetadata field : embeddedType.getAllDocumentFieldMetadata()) {
                    if (!field.getName().equals(fieldName)) continue;
                    return property;
                }
            }
        }
        return null;
    }

    public static boolean isSortableField(EntityIndexBinding indexBinding, String fieldName) {
        PropertyMetadata property = FieldHelper.getPropertyMetadata(indexBinding, fieldName);
        for (SortableFieldMetadata sortableField : property.getSortableFieldMetadata()) {
            if (!fieldName.equals(sortableField.getFieldName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmbeddedField(String field) {
        return field.contains(".");
    }

    public static String getEmbeddedFieldPath(String field) {
        return field.substring(0, field.lastIndexOf("."));
    }

    public static String getEmbeddedFieldPropertyName(String field) {
        return field.substring(field.lastIndexOf(".") + 1);
    }

    public static enum ExtendedFieldType {
        STRING,
        BOOLEAN,
        DATE,
        CALENDAR,
        INSTANT,
        LOCAL_DATE,
        LOCAL_TIME,
        LOCAL_DATE_TIME,
        OFFSET_DATE_TIME,
        OFFSET_TIME,
        ZONED_DATE_TIME,
        YEAR,
        YEAR_MONTH,
        MONTH_DAY,
        INTEGER{

            @Override
            public boolean isNumeric() {
                return true;
            }
        }
        ,
        LONG{

            @Override
            public boolean isNumeric() {
                return true;
            }
        }
        ,
        FLOAT{

            @Override
            public boolean isNumeric() {
                return true;
            }
        }
        ,
        DOUBLE{

            @Override
            public boolean isNumeric() {
                return true;
            }
        }
        ,
        UNKNOWN_NUMERIC{

            @Override
            public boolean isNumeric() {
                return true;
            }
        }
        ,
        UNKNOWN;


        public boolean isNumeric() {
            return false;
        }
    }
}

