/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import java.util.Date;
import java.util.HashMap;
import javax.persistence.Entity;
import javax.persistence.Id;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.elasticsearch.cfg.IndexSchemaManagementStrategy;
import org.hibernate.search.elasticsearch.testutil.JsonHelper;
import org.hibernate.search.elasticsearch.testutil.TestElasticsearchClient;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.test.SearchInitializationTestBase;
import org.hibernate.search.test.util.ImmutableTestConfiguration;
import org.hibernate.search.test.util.TestConfiguration;
import org.hibernate.search.test.util.impl.ExceptionMatcherBuilder;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ElasticsearchSchemaMigrationIT
extends SearchInitializationTestBase {
    private static final String MERGE_FAILED_MESSAGE_ID = "HSEARCH400035";
    private static final String MAPPING_CREATION_FAILED_MESSAGE_ID = "HSEARCH400020";
    private static final String ELASTICSEARCH_REQUEST_FAILED_MESSAGE_ID = "HSEARCH400007";
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public TestElasticsearchClient elasticSearchClient = new TestElasticsearchClient();

    protected void init(Class<?> ... annotatedClasses) {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("hibernate.search.default.elasticsearch.index_schema_management_strategy", IndexSchemaManagementStrategy.MERGE.name());
        this.init((TestConfiguration)new ImmutableTestConfiguration(settings, (Class[])annotatedClasses));
    }

    @Test
    public void nothingToDo() throws Exception {
        this.elasticSearchClient.deleteAndCreateIndex(SimpleDateEntity.class);
        this.elasticSearchClient.putMapping(SimpleDateEntity.class, "{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'date','index': 'not_analyzed','ignore_malformed': true},'NOTmyField': {'type': 'date','index': 'not_analyzed'}}}");
        this.elasticSearchClient.deleteAndCreateIndex(SimpleBooleanEntity.class);
        this.elasticSearchClient.putMapping(SimpleBooleanEntity.class, "{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'boolean','index': 'not_analyzed'},'NOTmyField': {'type': 'boolean','index': 'not_analyzed'}}}");
        this.init(SimpleDateEntity.class, SimpleBooleanEntity.class);
        JsonHelper.assertJsonEquals("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'date','format': 'strict_date_optional_time||epoch_millis','ignore_malformed': true},'NOTmyField': {'type': 'date','format': 'strict_date_optional_time||epoch_millis'}}}", this.elasticSearchClient.getMapping(SimpleDateEntity.class));
        JsonHelper.assertJsonEquals("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'boolean'},'NOTmyField': {'type': 'boolean'}}}", this.elasticSearchClient.getMapping(SimpleBooleanEntity.class));
    }

    @Test
    public void mapping_missing() throws Exception {
        this.elasticSearchClient.deleteAndCreateIndex(SimpleBooleanEntity.class);
        this.init(SimpleBooleanEntity.class);
        JsonHelper.assertJsonEquals("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'boolean'}}}", this.elasticSearchClient.getMapping(SimpleBooleanEntity.class));
    }

    @Test
    public void rootMapping_attribute_missing() throws Exception {
        this.elasticSearchClient.deleteAndCreateIndex(SimpleBooleanEntity.class);
        this.elasticSearchClient.putMapping(SimpleBooleanEntity.class, "{'properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'boolean','index': 'not_analyzed'},'NOTmyField': {'type': 'boolean','index': 'not_analyzed'}}}");
        this.init(SimpleBooleanEntity.class);
        JsonHelper.assertJsonEquals("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'boolean'},'NOTmyField': {'type': 'boolean'}}}", this.elasticSearchClient.getMapping(SimpleBooleanEntity.class));
    }

    @Test
    public void property_missing() throws Exception {
        this.elasticSearchClient.deleteAndCreateIndex(SimpleDateEntity.class);
        this.elasticSearchClient.putMapping(SimpleDateEntity.class, "{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'NOTmyField': {'type': 'date','index': 'not_analyzed'}}}");
        this.init(SimpleDateEntity.class);
        JsonHelper.assertJsonEquals("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'date','format': 'strict_date_optional_time||epoch_millis'},'NOTmyField': {'type': 'date','format': 'strict_date_optional_time||epoch_millis'}}}", this.elasticSearchClient.getMapping(SimpleDateEntity.class));
    }

    @Test
    public void property_attribute_invalid() throws Exception {
        this.elasticSearchClient.deleteAndCreateIndex(SimpleDateEntity.class);
        this.elasticSearchClient.putMapping(SimpleDateEntity.class, "{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'date','index': 'analyzed'}}}");
        this.thrown.expect(ExceptionMatcherBuilder.isException(SearchException.class).withMessage(MERGE_FAILED_MESSAGE_ID).causedBy(SearchException.class).withMessage(MAPPING_CREATION_FAILED_MESSAGE_ID).causedBy(SearchException.class).withMessage(ELASTICSEARCH_REQUEST_FAILED_MESSAGE_ID).withMessage("index").build());
        this.init(SimpleDateEntity.class);
    }

    @Indexed
    @Entity
    public static class SimpleDateEntity {
        @DocumentId
        @Id
        Long id;
        @Field
        Date myField;
    }

    @Indexed
    @Entity
    public static class SimpleBooleanEntity {
        @DocumentId
        @Id
        Long id;
        @Field
        Boolean myField;
    }
}

