/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.testutil;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.searchbox.action.AbstractAction;
import io.searchbox.action.Action;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestClientFactory;
import io.searchbox.client.JestResult;
import io.searchbox.client.config.HttpClientConfig;
import io.searchbox.cluster.Health;
import io.searchbox.core.Index;
import io.searchbox.indices.CreateIndex;
import io.searchbox.indices.DeleteIndex;
import io.searchbox.indices.mapping.GetMapping;
import io.searchbox.indices.mapping.PutMapping;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import org.hibernate.search.elasticsearch.impl.DefaultGsonService;
import org.hibernate.search.elasticsearch.impl.IndexNameNormalizer;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.junit.rules.ExternalResource;

public class TestElasticsearchClient
extends ExternalResource {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);
    private JestClient client;
    private final List<String> createdIndicesNames = Lists.newArrayList();

    public void deleteAndCreateIndex(Class<?> rootClass) throws IOException {
        this.deleteAndCreateIndex(IndexNameNormalizer.getElasticsearchIndexName((String)rootClass.getName()));
    }

    public void registerForCleanup(Class<?> rootClass) {
        this.createdIndicesNames.add(IndexNameNormalizer.getElasticsearchIndexName((String)rootClass.getName()));
    }

    public void putMapping(Class<?> mappedAndRootClass, String mappingJson) throws IOException {
        this.putMapping(mappedAndRootClass, mappedAndRootClass, mappingJson);
    }

    public void putMapping(String indexName, Class<?> mappedClass, String mappingJson) throws IOException {
        this.putMapping(indexName, mappedClass.getName(), mappingJson);
    }

    public void putMapping(Class<?> rootClass, Class<?> mappedClass, String mappingJson) throws IOException {
        this.putMapping(IndexNameNormalizer.getElasticsearchIndexName((String)rootClass.getName()), mappedClass.getName(), mappingJson);
    }

    public String getMapping(String indexName, Class<?> mappedClass) throws IOException {
        return this.getMapping(indexName, mappedClass.getName());
    }

    public String getMapping(Class<?> mappedAndRootClass) throws IOException {
        return this.getMapping(mappedAndRootClass, mappedAndRootClass);
    }

    public String getMapping(Class<?> rootClass, Class<?> mappedClass) throws IOException {
        return this.getMapping(IndexNameNormalizer.getElasticsearchIndexName((String)rootClass.getName()), mappedClass.getName());
    }

    public void deleteAndCreateIndex(String indexName) throws IOException {
        this.tryDeleteESIndex(indexName);
        JestResult result = this.client.execute((Action)new CreateIndex.Builder(indexName).build());
        this.registerForCleanup(indexName);
        if (!result.isSucceeded()) {
            throw new AssertionFailure("Error while creating index '" + indexName + "' for tests:" + result.getErrorMessage());
        }
        this.waitForIndexCreation(indexName);
    }

    public void registerForCleanup(String indexName) {
        this.createdIndicesNames.add(indexName);
    }

    private void waitForIndexCreation(final String indexNameToWaitFor) throws IOException {
        Health.Builder healthBuilder = (Health.Builder)((Health.Builder)new Health.Builder().setParameter("wait_for_status", (Object)"green")).setParameter("timeout", (Object)"10000ms");
        Health health = new Health(healthBuilder){

            protected String buildURI() {
                try {
                    return super.buildURI() + URLEncoder.encode(indexNameToWaitFor, AbstractAction.CHARSET);
                }
                catch (UnsupportedEncodingException e) {
                    throw new AssertionFailure("Unexpectedly unsupported charset", (Throwable)e);
                }
            }
        };
        JestResult result = this.client.execute((Action)health);
        if (!result.isSucceeded()) {
            String status = result.getJsonObject().get("status").getAsString();
            throw new AssertionFailure("Error while waiting for creation of index '" + indexNameToWaitFor + "' for tests (status was '" + status + "'):" + result.getErrorMessage());
        }
    }

    public void putMapping(String indexName, String mappingName, String mappingJson) throws IOException {
        JsonElement mappingJsonElement = this.toJsonElement(mappingJson);
        JestResult result = this.client.execute((Action)new PutMapping.Builder(indexName, mappingName, (Object)mappingJsonElement).build());
        if (!result.isSucceeded()) {
            throw new AssertionFailure("Error while putting mapping '" + mappingName + "' on index '" + indexName + "' for tests:" + result.getErrorMessage());
        }
    }

    public String getMapping(String indexName, String mappingName) throws IOException {
        JestResult result = this.client.execute((Action)((GetMapping.Builder)((GetMapping.Builder)new GetMapping.Builder().addIndex(indexName)).addType(mappingName)).build());
        if (!result.isSucceeded()) {
            throw new AssertionFailure("Error while getting mapping '" + mappingName + "' on index '" + indexName + "' for tests:" + result.getErrorMessage());
        }
        JsonElement index = result.getJsonObject().get(indexName);
        if (index == null) {
            return new JsonObject().toString();
        }
        JsonElement mappings = index.getAsJsonObject().get("mappings");
        if (mappings == null) {
            return new JsonObject().toString();
        }
        JsonElement mapping = mappings.getAsJsonObject().get(mappingName);
        if (mapping == null) {
            return new JsonObject().toString();
        }
        return mapping.toString();
    }

    public void index(String indexName, Class<?> mappedClass, String id, String jsonDocument) throws IOException {
        this.index(indexName, mappedClass.getName(), id, jsonDocument);
    }

    public void index(Class<?> mappedAndRootClass, String id, String jsonDocument) throws IOException {
        this.index(mappedAndRootClass, mappedAndRootClass, id, jsonDocument);
    }

    public void index(Class<?> rootClass, Class<?> mappedClass, String id, String jsonDocument) throws IOException {
        this.index(IndexNameNormalizer.getElasticsearchIndexName((String)rootClass.getName()), mappedClass.getName(), id, jsonDocument);
    }

    public void index(String indexName, String typeName, String id, String jsonDocument) throws IOException {
        JsonElement documentJsonElement = this.toJsonElement(jsonDocument);
        JestResult result = this.client.execute((Action)((Index.Builder)((Index.Builder)((Index.Builder)((Index.Builder)new Index.Builder((Object)documentJsonElement).index(indexName)).type(typeName)).id(id)).refresh(true)).build());
        if (!result.isSucceeded()) {
            throw new AssertionFailure("Error while indexing '" + jsonDocument + "' on index '" + indexName + "' for tests:" + result.getErrorMessage());
        }
    }

    protected void before() throws Throwable {
        JestClientFactory factory = new JestClientFactory();
        Gson gson = new DefaultGsonService().getGson();
        factory.setHttpClientConfig(((HttpClientConfig.Builder)((HttpClientConfig.Builder)((HttpClientConfig.Builder)new HttpClientConfig.Builder("http://localhost:9200").readTimeout(60000)).connTimeout(2000)).gson(gson)).build());
        this.client = factory.getObject();
    }

    protected void after() {
        for (String indexName : this.createdIndicesNames) {
            this.tryDeleteESIndex(indexName);
        }
        this.createdIndicesNames.clear();
        this.client.shutdownClient();
        this.client = null;
    }

    private void tryDeleteESIndex(String indexName) {
        try {
            JestResult result = this.client.execute((Action)new DeleteIndex.Builder(indexName).build());
            if (!result.isSucceeded() && result.getResponseCode() != 404) {
                LOG.warnf("Error while trying to delete index '%s' as part of test cleanup: %s", (Object)indexName, (Object)result.getErrorMessage());
            }
        }
        catch (IOException | RuntimeException e) {
            LOG.warnf((Throwable)e, "Error while trying to delete index '%s' as part of test cleanup", (Object)indexName);
        }
    }

    private JsonElement toJsonElement(String jsonAsString) {
        return new JsonParser().parse(jsonAsString);
    }
}

